/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.send;

import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transport;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.common.OnDemandCounter;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.settings.Settings;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class ReportQueue {
    private static final int MS_PER_SECOND = 1000;
    private static final int MS_PER_MINUTE = 60000;
    private static final int MAX_DELAY_MS = 3600000;
    private final double ratePerMinute;
    private final double base;
    private final long stepDurationMs;
    private final int queueCapacity;
    private final BlockingQueue<Runnable> queue;
    private final ThreadPoolExecutor singleThreadExecutor;
    private final Transport<CrashlyticsReport> transport;
    private final OnDemandCounter onDemandCounter;
    private int step;
    private long lastUpdatedMs;

    ReportQueue(Transport<CrashlyticsReport> transport, Settings settings, OnDemandCounter onDemandCounter) {
        this(settings.onDemandUploadRatePerMinute, settings.onDemandBackoffBase, (long)settings.onDemandBackoffStepDurationSeconds * 1000L, transport, onDemandCounter);
    }

    ReportQueue(double ratePerMinute, double base, long stepDurationMs, Transport<CrashlyticsReport> transport, OnDemandCounter onDemandCounter) {
        this.ratePerMinute = ratePerMinute;
        this.base = base;
        this.stepDurationMs = stepDurationMs;
        this.transport = transport;
        this.onDemandCounter = onDemandCounter;
        this.queueCapacity = (int)ratePerMinute;
        this.queue = new ArrayBlockingQueue<Runnable>(this.queueCapacity);
        this.singleThreadExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.queue);
        this.step = 0;
        this.lastUpdatedMs = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskCompletionSource<CrashlyticsReportWithSessionId> enqueueReport(CrashlyticsReportWithSessionId reportWithSessionId, boolean isOnDemand) {
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            TaskCompletionSource tcs = new TaskCompletionSource();
            if (isOnDemand) {
                this.onDemandCounter.incrementRecordedOnDemandExceptions();
                if (this.isQueueAvailable()) {
                    Logger.getLogger().d("Enqueueing report: " + reportWithSessionId.getSessionId());
                    Logger.getLogger().d("Queue size: " + this.queue.size());
                    this.singleThreadExecutor.execute(new ReportRunnable(reportWithSessionId, tcs));
                    Logger.getLogger().d("Closing task for report: " + reportWithSessionId.getSessionId());
                    tcs.trySetResult((Object)reportWithSessionId);
                    return tcs;
                }
                this.calcStep();
                Logger.getLogger().d("Dropping report due to queue being full: " + reportWithSessionId.getSessionId());
                this.onDemandCounter.incrementDroppedOnDemandExceptions();
                tcs.trySetResult((Object)reportWithSessionId);
                return tcs;
            }
            this.sendReport(reportWithSessionId, (TaskCompletionSource<CrashlyticsReportWithSessionId>)tcs);
            return tcs;
        }
    }

    private void sendReport(CrashlyticsReportWithSessionId reportWithSessionId, TaskCompletionSource<CrashlyticsReportWithSessionId> tcs) {
        Logger.getLogger().d("Sending report through Google DataTransport: " + reportWithSessionId.getSessionId());
        this.transport.schedule(Event.ofUrgent((Object)reportWithSessionId.getReport()), error -> {
            if (error != null) {
                tcs.trySetException(error);
                return;
            }
            tcs.trySetResult((Object)reportWithSessionId);
        });
    }

    private boolean isQueueAvailable() {
        return this.queue.size() < this.queueCapacity;
    }

    private boolean isQueueFull() {
        return this.queue.size() == this.queueCapacity;
    }

    private double calcDelay() {
        return Math.min(3600000.0, 60000.0 / this.ratePerMinute * Math.pow(this.base, this.calcStep()));
    }

    private int calcStep() {
        int calcStep;
        if (this.lastUpdatedMs == 0L) {
            this.lastUpdatedMs = this.now();
        }
        int delta = (int)((this.now() - this.lastUpdatedMs) / this.stepDurationMs);
        int n = calcStep = this.isQueueFull() ? Math.min(100, this.step + delta) : Math.max(0, this.step - delta);
        if (this.step != calcStep) {
            this.step = calcStep;
            this.lastUpdatedMs = this.now();
        }
        return calcStep;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private static void sleep(double millis) {
        try {
            Thread.sleep((long)millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final class ReportRunnable
    implements Runnable {
        private final CrashlyticsReportWithSessionId reportWithSessionId;
        private final TaskCompletionSource<CrashlyticsReportWithSessionId> tcs;

        private ReportRunnable(CrashlyticsReportWithSessionId reportWithSessionId, TaskCompletionSource<CrashlyticsReportWithSessionId> tcs) {
            this.reportWithSessionId = reportWithSessionId;
            this.tcs = tcs;
        }

        @Override
        public void run() {
            ReportQueue.this.sendReport(this.reportWithSessionId, (TaskCompletionSource<CrashlyticsReportWithSessionId>)this.tcs);
            ReportQueue.this.onDemandCounter.resetDroppedOnDemandExceptions();
            double delay = ReportQueue.this.calcDelay();
            Logger.getLogger().d("Delay for: " + String.format(Locale.US, "%.2f", delay / 1000.0) + " s for report: " + this.reportWithSessionId.getSessionId());
            ReportQueue.sleep(delay);
        }
    }
}

