/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.NativeSessionFileProvider;
import com.google.firebase.inject.Provider;
import java.io.File;

public final class ProviderProxyNativeComponent
implements CrashlyticsNativeComponent {
    private static final NativeSessionFileProvider MISSING_NATIVE_SESSION_FILE_PROVIDER = new MissingNativeSessionFileProvider();
    private final Provider<CrashlyticsNativeComponent> provider;

    public ProviderProxyNativeComponent(Provider<CrashlyticsNativeComponent> provider) {
        this.provider = provider;
    }

    @Override
    public boolean hasCrashDataForSession(@NonNull String sessionId) {
        CrashlyticsNativeComponent nativeComponent = (CrashlyticsNativeComponent)this.provider.get();
        if (nativeComponent != null) {
            return nativeComponent.hasCrashDataForSession(sessionId);
        }
        return false;
    }

    @Override
    public boolean openSession(@NonNull String sessionId) {
        CrashlyticsNativeComponent nativeComponent = (CrashlyticsNativeComponent)this.provider.get();
        if (nativeComponent != null) {
            return nativeComponent.openSession(sessionId);
        }
        return true;
    }

    @Override
    public boolean finalizeSession(@NonNull String sessionId) {
        CrashlyticsNativeComponent nativeComponent = (CrashlyticsNativeComponent)this.provider.get();
        if (nativeComponent != null) {
            return nativeComponent.finalizeSession(sessionId);
        }
        return true;
    }

    @Override
    @NonNull
    public NativeSessionFileProvider getSessionFileProvider(@NonNull String sessionId) {
        CrashlyticsNativeComponent nativeComponent = (CrashlyticsNativeComponent)this.provider.get();
        if (nativeComponent != null) {
            return nativeComponent.getSessionFileProvider(sessionId);
        }
        return MISSING_NATIVE_SESSION_FILE_PROVIDER;
    }

    @Override
    public void writeBeginSession(@NonNull String sessionId, @NonNull String generator, long startedAtSeconds) {
        CrashlyticsNativeComponent nativeComponent = (CrashlyticsNativeComponent)this.provider.get();
        if (nativeComponent != null) {
            nativeComponent.writeBeginSession(sessionId, generator, startedAtSeconds);
        }
    }

    @Override
    public void writeSessionApp(@NonNull String sessionId, @NonNull String appIdentifier, @NonNull String versionCode, @NonNull String versionName, @NonNull String installUuid, int deliveryMechanism, @NonNull String unityVersion) {
        CrashlyticsNativeComponent nativeComponent = (CrashlyticsNativeComponent)this.provider.get();
        if (nativeComponent != null) {
            nativeComponent.writeSessionApp(sessionId, appIdentifier, versionCode, versionName, installUuid, deliveryMechanism, unityVersion);
        }
    }

    @Override
    public void writeSessionOs(@NonNull String sessionId, @NonNull String osRelease, @NonNull String osCodeName, boolean isRooted) {
        CrashlyticsNativeComponent nativeComponent = (CrashlyticsNativeComponent)this.provider.get();
        if (nativeComponent != null) {
            nativeComponent.writeSessionOs(sessionId, osRelease, osCodeName, isRooted);
        }
    }

    @Override
    public void writeSessionDevice(@NonNull String sessionId, int arch, @NonNull String model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, int state, @NonNull String manufacturer, @NonNull String modelClass) {
        CrashlyticsNativeComponent nativeComponent = (CrashlyticsNativeComponent)this.provider.get();
        if (nativeComponent != null) {
            nativeComponent.writeSessionDevice(sessionId, arch, model, availableProcessors, totalRam, diskSpace, isEmulator, state, manufacturer, modelClass);
        }
    }

    private static final class MissingNativeSessionFileProvider
    implements NativeSessionFileProvider {
        private MissingNativeSessionFileProvider() {
        }

        @Override
        public File getMinidumpFile() {
            return null;
        }

        @Override
        public File getBinaryImagesFile() {
            return null;
        }

        @Override
        public File getMetadataFile() {
            return null;
        }

        @Override
        public File getSessionFile() {
            return null;
        }

        @Override
        public File getAppFile() {
            return null;
        }

        @Override
        public File getDeviceFile() {
            return null;
        }

        @Override
        public File getOsFile() {
            return null;
        }
    }
}

