/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.network;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.network.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpGetRequest {
    private static final String METHOD_GET = "GET";
    private static final int DEFAULT_TIMEOUT_MS = 10000;
    private static final int READ_BUFFER_SIZE = 8192;
    private final String url;
    private final Map<String, String> queryParams;
    private final Map<String, String> headers;

    public HttpGetRequest(String url, Map<String, String> queryParams) {
        this.url = url;
        this.queryParams = queryParams;
        this.headers = new HashMap<String, String>();
    }

    public HttpGetRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpGetRequest header(Map.Entry<String, String> entry) {
        return this.header(entry.getKey(), entry.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute() throws IOException {
        InputStream stream = null;
        HttpURLConnection connection = null;
        String body = null;
        int responseCode = -1;
        try {
            String urlWithParams = this.createUrlWithParams(this.url, this.queryParams);
            Logger.getLogger().v("GET Request URL: " + urlWithParams);
            connection = (HttpsURLConnection)new URL(urlWithParams).openConnection();
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            connection.setRequestMethod(METHOD_GET);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.connect();
            responseCode = connection.getResponseCode();
            stream = connection.getInputStream();
            if (stream != null) {
                body = this.readStream(stream);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return new HttpResponse(responseCode, body);
    }

    private String createUrlWithParams(String url, Map<String, String> queryParams) {
        String queryParamsString = this.createParamsString(queryParams);
        if (queryParamsString.isEmpty()) {
            return url;
        }
        if (url.contains("?")) {
            if (!url.endsWith("&")) {
                queryParamsString = "&" + queryParamsString;
            }
            return url + queryParamsString;
        }
        return url + "?" + queryParamsString;
    }

    private String createParamsString(Map<String, String> queryParams) {
        StringBuilder paramsString = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = queryParams.entrySet().iterator();
        Map.Entry<String, String> entry = iterator.next();
        paramsString.append(entry.getKey() + "=" + (entry.getValue() != null ? entry.getValue() : ""));
        while (iterator.hasNext()) {
            entry = iterator.next();
            paramsString.append("&" + entry.getKey() + "=" + (entry.getValue() != null ? entry.getValue() : ""));
        }
        return paramsString.toString();
    }

    private String readStream(InputStream stream) throws IOException {
        int charsRead;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        char[] charBuffer = new char[8192];
        StringBuilder result = new StringBuilder();
        while ((charsRead = reader.read(charBuffer)) != -1) {
            result.append(charBuffer, 0, charsRead);
        }
        return result.toString();
    }
}

