/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UserMetadata {
    static final int MAX_ATTRIBUTES = 64;
    static final int MAX_ATTRIBUTE_SIZE = 1024;
    private String userId = null;
    private final Map<String, String> attributes = new HashMap<String, String>();

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String identifier) {
        this.userId = UserMetadata.sanitizeAttribute(identifier);
    }

    @NonNull
    public Map<String, String> getCustomKeys() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setCustomKey(final String key, final String value) {
        this.setSyncCustomKeys((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(UserMetadata.sanitizeKey(key), UserMetadata.sanitizeAttribute(value));
            }
        });
    }

    public void setCustomKeys(Map<String, String> keysAndValues) {
        this.setSyncCustomKeys(keysAndValues);
    }

    private synchronized void setSyncCustomKeys(Map<String, String> keysAndValues) {
        HashMap<String, String> currentKeys = new HashMap<String, String>();
        HashMap<String, String> newKeys = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : keysAndValues.entrySet()) {
            String value;
            String key = UserMetadata.sanitizeKey(entry.getKey());
            String string = value = entry.getValue() == null ? "" : UserMetadata.sanitizeAttribute(entry.getValue());
            if (this.attributes.containsKey(key)) {
                currentKeys.put(key, value);
                continue;
            }
            newKeys.put(key, value);
        }
        this.attributes.putAll(currentKeys);
        if (this.attributes.size() + newKeys.size() > 64) {
            int keySlotsLeft = 64 - this.attributes.size();
            Logger.getLogger().v("Exceeded maximum number of custom attributes (64).");
            ArrayList newKeyList = new ArrayList(newKeys.keySet());
            newKeys.keySet().retainAll(newKeyList.subList(0, keySlotsLeft));
        }
        this.attributes.putAll(newKeys);
    }

    private static String sanitizeKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Custom attribute key must not be null.");
        }
        return UserMetadata.sanitizeAttribute(key);
    }

    private static String sanitizeAttribute(String input) {
        if (input != null && (input = input.trim()).length() > 1024) {
            input = input.substring(0, 1024);
        }
        return input;
    }
}

