/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public final class ImmutableList<E>
implements List<E>,
RandomAccess {
    private final List<E> immutableList;

    @NonNull
    public static <E> ImmutableList<E> from(E ... elements) {
        return new ImmutableList<E>(Arrays.asList(elements));
    }

    @NonNull
    public static <E> ImmutableList<E> from(@NonNull List<E> mutableList) {
        return new ImmutableList<E>(mutableList);
    }

    private ImmutableList(List<E> mutableList) {
        this.immutableList = Collections.unmodifiableList(mutableList);
    }

    @Override
    public int size() {
        return this.immutableList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.immutableList.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.immutableList.contains(o);
    }

    @Override
    @NonNull
    public Iterator<E> iterator() {
        return this.immutableList.iterator();
    }

    @Override
    @Nullable
    public Object[] toArray() {
        return this.immutableList.toArray();
    }

    @Override
    public <T> T[] toArray(@Nullable T[] a) {
        return this.immutableList.toArray(a);
    }

    @Override
    public boolean add(@NonNull E e) {
        return this.immutableList.add(e);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.immutableList.remove(o);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.immutableList.containsAll(c);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends E> c) {
        return this.immutableList.addAll(c);
    }

    @Override
    public boolean addAll(int index, @NonNull Collection<? extends E> c) {
        return this.immutableList.addAll(index, c);
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        return this.immutableList.removeAll(c);
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        return this.immutableList.retainAll(c);
    }

    @Override
    public void clear() {
        this.immutableList.clear();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this.immutableList.equals(o);
    }

    @Override
    public int hashCode() {
        return this.immutableList.hashCode();
    }

    @Override
    @NonNull
    public E get(int index) {
        return this.immutableList.get(index);
    }

    @Override
    @NonNull
    public E set(int index, @NonNull E element) {
        return this.immutableList.set(index, element);
    }

    @Override
    public void add(int index, @NonNull E element) {
        this.immutableList.add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.immutableList.remove(index);
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return this.immutableList.indexOf(o);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.immutableList.lastIndexOf(o);
    }

    @Override
    @NonNull
    public ListIterator<E> listIterator() {
        return this.immutableList.listIterator();
    }

    @Override
    @NonNull
    public ListIterator<E> listIterator(int index) {
        return this.immutableList.listIterator(index);
    }

    @Override
    @NonNull
    public List<E> subList(int fromIndex, int toIndex) {
        return this.immutableList.subList(fromIndex, toIndex);
    }
}

