/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings.network;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AbstractSpiCall;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.ResponseParser;
import com.google.firebase.crashlytics.internal.network.HttpMethod;
import com.google.firebase.crashlytics.internal.network.HttpRequest;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.network.HttpResponse;
import com.google.firebase.crashlytics.internal.settings.model.AppRequestData;
import com.google.firebase.crashlytics.internal.settings.network.AppSpiCall;
import java.io.IOException;

abstract class AbstractAppSpiCall
extends AbstractSpiCall
implements AppSpiCall {
    public static final String ORGANIZATION_ID_PARAM = "org_id";
    public static final String APP_IDENTIFIER_PARAM = "app[identifier]";
    public static final String APP_NAME_PARAM = "app[name]";
    public static final String APP_INSTANCE_IDENTIFIER_PARAM = "app[instance_identifier]";
    public static final String APP_DISPLAY_VERSION_PARAM = "app[display_version]";
    public static final String APP_BUILD_VERSION_PARAM = "app[build_version]";
    public static final String APP_SOURCE_PARAM = "app[source]";
    public static final String APP_MIN_SDK_VERSION_PARAM = "app[minimum_sdk_version]";
    public static final String APP_BUILT_SDK_VERSION_PARAM = "app[built_sdk_version]";
    private final String version;

    public AbstractAppSpiCall(String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, HttpMethod method, String version) {
        super(protocolAndHostOverride, url, requestFactory, method);
        this.version = version;
    }

    @Override
    public boolean invoke(AppRequestData requestData, boolean dataCollectionToken) {
        if (!dataCollectionToken) {
            throw new RuntimeException("An invalid data collection token was used.");
        }
        HttpRequest httpRequest = this.getHttpRequest();
        httpRequest = this.applyHeadersTo(httpRequest, requestData);
        httpRequest = this.applyMultipartDataTo(httpRequest, requestData);
        Logger.getLogger().d("Sending app info to " + this.getUrl());
        try {
            HttpResponse httpResponse = httpRequest.execute();
            int statusCode = httpResponse.code();
            String kind = "POST".equalsIgnoreCase(httpRequest.method()) ? "Create" : "Update";
            Logger.getLogger().d(kind + " app request ID: " + httpResponse.header("X-REQUEST-ID"));
            Logger.getLogger().d("Result was " + statusCode);
            return 0 == ResponseParser.parse(statusCode);
        }
        catch (IOException ioe) {
            Logger.getLogger().e("HTTP request failed.", ioe);
            throw new RuntimeException(ioe);
        }
    }

    private HttpRequest applyHeadersTo(HttpRequest request, AppRequestData requestData) {
        return request.header("X-CRASHLYTICS-ORG-ID", requestData.organizationId).header("X-CRASHLYTICS-GOOGLE-APP-ID", requestData.googleAppId).header("X-CRASHLYTICS-API-CLIENT-TYPE", "android").header("X-CRASHLYTICS-API-CLIENT-VERSION", this.version);
    }

    private HttpRequest applyMultipartDataTo(HttpRequest request, AppRequestData requestData) {
        request = request.part(ORGANIZATION_ID_PARAM, requestData.organizationId).part(APP_IDENTIFIER_PARAM, requestData.appId).part(APP_NAME_PARAM, requestData.name).part(APP_DISPLAY_VERSION_PARAM, requestData.displayVersion).part(APP_BUILD_VERSION_PARAM, requestData.buildVersion).part(APP_SOURCE_PARAM, Integer.toString(requestData.source)).part(APP_MIN_SDK_VERSION_PARAM, requestData.minSdkVersion).part(APP_BUILT_SDK_VERSION_PARAM, requestData.builtSdkVersion);
        if (!CommonUtils.isNullOrEmpty(requestData.instanceIdentifier)) {
            request.part(APP_INSTANCE_IDENTIFIER_PARAM, requestData.instanceIdentifier);
        }
        return request;
    }
}

