/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import com.google.firebase.crashlytics.internal.common.CurrentTimeProvider;
import com.google.firebase.crashlytics.internal.settings.DefaultSettingsJsonTransform;
import com.google.firebase.crashlytics.internal.settings.SettingsJsonTransform;
import com.google.firebase.crashlytics.internal.settings.SettingsV3JsonTransform;
import com.google.firebase.crashlytics.internal.settings.model.SettingsData;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingsJsonParser {
    private final CurrentTimeProvider currentTimeProvider;

    SettingsJsonParser(CurrentTimeProvider currentTimeProvider) {
        this.currentTimeProvider = currentTimeProvider;
    }

    public SettingsData parseSettingsJson(JSONObject settingsJson) throws JSONException {
        int version = settingsJson.getInt("settings_version");
        SettingsJsonTransform jsonTransform = SettingsJsonParser.getJsonTransformForVersion(version);
        return jsonTransform.buildFromJson(this.currentTimeProvider, settingsJson);
    }

    private static SettingsJsonTransform getJsonTransformForVersion(int settingsVersion) {
        switch (settingsVersion) {
            case 3: {
                return new SettingsV3JsonTransform();
            }
        }
        return new DefaultSettingsJsonTransform();
    }
}

