/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.util.Log;

public class Logger {
    public static final String TAG = "FirebaseCrashlytics";
    static final Logger DEFAULT_LOGGER = new Logger();
    private int logLevel = 4;

    public static Logger getLogger() {
        return DEFAULT_LOGGER;
    }

    public boolean isLoggable(String tag, int level) {
        return this.logLevel <= level || Log.isLoggable((String)tag, (int)level);
    }

    public void d(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 3)) {
            Log.d((String)tag, (String)text, (Throwable)throwable);
        }
    }

    public void v(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 2)) {
            Log.v((String)tag, (String)text, (Throwable)throwable);
        }
    }

    public void i(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 4)) {
            Log.i((String)tag, (String)text, (Throwable)throwable);
        }
    }

    public void w(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 5)) {
            Log.w((String)tag, (String)text, (Throwable)throwable);
        }
    }

    public void e(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 6)) {
            Log.e((String)tag, (String)text, (Throwable)throwable);
        }
    }

    public void d(String tag, String text) {
        this.d(tag, text, null);
    }

    public void v(String tag, String text) {
        this.v(tag, text, null);
    }

    public void i(String tag, String text) {
        this.i(tag, text, null);
    }

    public void w(String tag, String text) {
        this.w(tag, text, null);
    }

    public void e(String tag, String text) {
        this.e(tag, text, null);
    }

    public void log(int priority, String tag, String msg) {
        this.log(priority, tag, msg, false);
    }

    public void log(int priority, String tag, String msg, boolean forceLog) {
        if (forceLog || this.isLoggable(tag, priority)) {
            Log.println((int)priority, (String)tag, (String)msg);
        }
    }
}

