/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.core.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.MissingNativeComponent;
import com.google.firebase.crashlytics.internal.Onboarding;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.ExecutorUtils;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.settings.SettingsController;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class FirebaseCrashlytics {
    private final CrashlyticsCore core;

    @Nullable
    static FirebaseCrashlytics init(@NonNull FirebaseApp app, @NonNull FirebaseInstanceIdInternal instanceId, @Nullable CrashlyticsNativeComponent nativeComponent, @Nullable AnalyticsConnector analyticsConnector) {
        Context context = app.getApplicationContext();
        String appIdentifier = context.getPackageName();
        IdManager idManager = new IdManager(context, appIdentifier, instanceId);
        DataCollectionArbiter arbiter = new DataCollectionArbiter(app);
        if (nativeComponent == null) {
            nativeComponent = new MissingNativeComponent();
        }
        final Onboarding onboarding = new Onboarding(app, context, idManager, arbiter);
        final CrashlyticsCore core = new CrashlyticsCore(app, idManager, nativeComponent, arbiter, analyticsConnector);
        if (!onboarding.onPreExecute()) {
            Logger.getLogger().e("FirebaseCrashlytics", "Unable to start Crashlytics.");
            return null;
        }
        final ExecutorService threadPoolExecutor = ExecutorUtils.buildSingleThreadExecutorService("com.google.firebase.crashlytics.startup");
        final SettingsController settingsController = onboarding.retrieveSettingsData(context, app, threadPoolExecutor);
        final boolean finishCoreInBackground = core.onPreExecute(settingsController);
        Tasks.call((Executor)threadPoolExecutor, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                onboarding.doOnboarding(threadPoolExecutor, settingsController);
                if (finishCoreInBackground) {
                    core.doBackgroundInitializationAsync(settingsController);
                }
                return null;
            }
        });
        return new FirebaseCrashlytics(core);
    }

    private FirebaseCrashlytics(@NonNull CrashlyticsCore core) {
        this.core = core;
    }

    @NonNull
    public static FirebaseCrashlytics getInstance() {
        FirebaseApp app = FirebaseApp.getInstance();
        FirebaseCrashlytics instance = (FirebaseCrashlytics)app.get(FirebaseCrashlytics.class);
        if (instance == null) {
            throw new NullPointerException("FirebaseCrashlytics component is not present.");
        }
        return instance;
    }

    public void recordException(@NonNull Throwable throwable) {
        this.core.logException(throwable);
    }

    public void log(@NonNull String message) {
        this.core.log(message);
    }

    public void setUserId(@NonNull String identifier) {
        this.core.setUserId(identifier);
    }

    public void setCustomKey(@NonNull String key, boolean value) {
        this.core.setCustomKey(key, Boolean.toString(value));
    }

    public void setCustomKey(@NonNull String key, double value) {
        this.core.setCustomKey(key, Double.toString(value));
    }

    public void setCustomKey(@NonNull String key, float value) {
        this.core.setCustomKey(key, Float.toString(value));
    }

    public void setCustomKey(@NonNull String key, int value) {
        this.core.setCustomKey(key, Integer.toString(value));
    }

    public void setCustomKey(@NonNull String key, long value) {
        this.core.setCustomKey(key, Long.toString(value));
    }

    public void setCustomKey(@NonNull String key, @NonNull String value) {
        this.core.setCustomKey(key, value);
    }

    @NonNull
    public Task<Boolean> checkForUnsentReports() {
        return this.core.checkForUnsentReports();
    }

    public void sendUnsentReports() {
        this.core.sendUnsentReports();
    }

    public void deleteUnsentReports() {
        this.core.deleteUnsentReports();
    }

    public boolean didCrashOnPreviousExecution() {
        return this.core.didCrashOnPreviousExecution();
    }

    public void setCrashlyticsCollectionEnabled(boolean enabled) {
        this.core.setCrashlyticsCollectionEnabled(enabled);
    }
}

