/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.android.project;

import com.google.firebase.crashlytics.buildtools.android.project.BuildIdWriter;
import com.google.firebase.crashlytics.buildtools.android.project.ResourceXmlHelper;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.xml.sax.SAXException;

public class XmlBuildIdWriter
implements BuildIdWriter {
    private final File _resourceFile;

    public XmlBuildIdWriter(File resourceFile) {
        this._resourceFile = resourceFile;
    }

    @Override
    public boolean fileExists() {
        return this._resourceFile.exists() && this._resourceFile.isFile();
    }

    private void createEmptyResourceFile() throws IOException {
        File parentDir = this._resourceFile.getParentFile();
        if (parentDir != null) {
            if (parentDir.exists() && !parentDir.isDirectory()) {
                throw new IOException("Could not create resource file, path is not a directory: " + parentDir);
            }
            FileUtils.verifyDirectory(parentDir);
        }
        ResourceXmlHelper.writeInputStreamToFile(ResourceXmlHelper.createEmptyResourceFileStream(), this._resourceFile);
    }

    @Override
    public void removeBuildId() {
        this._resourceFile.delete();
    }

    @Override
    public String updateBuildId() throws IOException {
        String buildId = UUID.randomUUID().toString();
        this.setBuildId(buildId);
        return buildId;
    }

    @Override
    public void setBuildId(String buildId) throws IOException {
        if (!this.fileExists()) {
            this.createEmptyResourceFile();
        }
        try {
            InputStream is = this.updateBuildId(buildId);
            ResourceXmlHelper.writeInputStreamToFile(is, this._resourceFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Crashlytics could not create: " + this._resourceFile, e);
        }
    }

    private InputStream updateBuildId(String newId) throws SAXException, IOException {
        ByteArrayInputStream toReturn = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n<resources xmlns:tools=\"http://schemas.android.com/tools\">\n<!--\n  This file is automatically generated by Crashlytics to uniquely \n  identify individual builds of your Android application.\n\n  Do NOT modify, delete, or commit to source control!\n-->\n<string tools:ignore=\"UnusedResources,TypographyDashes\" name=\"com.crashlytics.android.build_id\" translatable=\"false\">" + newId + "</string>\n</resources>\n").getBytes());
        return toReturn;
    }

    @Override
    public File getResourceFile() {
        return this._resourceFile;
    }
}

