/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.android.project;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.android.project.BuildIdReader;
import com.google.firebase.crashlytics.buildtools.android.project.ResourceXmlHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class XmlBuildIdReader
implements BuildIdReader {
    protected final DocumentBuilder _docBuilder;

    public static XmlBuildIdReader create(File resourceFile) {
        try {
            return new FileXmlBuildIdReader(resourceFile, DocumentBuilderFactory.newInstance().newDocumentBuilder());
        }
        catch (ParserConfigurationException e) {
            Buildtools.logE("Crashlytics experienced an unrecoverable parser configuration exception", e);
            throw new RuntimeException(e);
        }
    }

    public static XmlBuildIdReader create(String xmlString) {
        try {
            return new StringXmlBuildIdReader(xmlString, DocumentBuilderFactory.newInstance().newDocumentBuilder());
        }
        catch (ParserConfigurationException e) {
            Buildtools.logE("Crashlytics experienced an unrecoverable parser configuration exception", e);
            throw new RuntimeException(e);
        }
    }

    protected abstract Document parseXmlSource() throws SAXException, IOException;

    protected XmlBuildIdReader(DocumentBuilder builder) {
        this._docBuilder = builder;
    }

    protected DocumentBuilder getDocumentBuilder() {
        return this._docBuilder;
    }

    @Override
    public String getBuildId() throws IOException {
        String toReturn = null;
        try {
            Document doc = this.parseXmlSource();
            if (doc == null) {
                return null;
            }
            Element buildIdElement = ResourceXmlHelper.getBuildIdElement(doc);
            if (buildIdElement != null) {
                toReturn = buildIdElement.getTextContent();
            }
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return toReturn;
    }

    private static class StringXmlBuildIdReader
    extends XmlBuildIdReader {
        private final String string;

        StringXmlBuildIdReader(String xmlString, DocumentBuilder docBuilder) {
            super(docBuilder);
            this.string = xmlString;
        }

        @Override
        protected Document parseXmlSource() throws IOException, SAXException {
            if (this.string == null || this.string.isEmpty()) {
                return null;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(this.string.getBytes(StandardCharsets.UTF_8));
            return this.getDocumentBuilder().parse(stream);
        }
    }

    private static class FileXmlBuildIdReader
    extends XmlBuildIdReader {
        private final File file;

        FileXmlBuildIdReader(File xmlFile, DocumentBuilder docBuilder) {
            super(docBuilder);
            this.file = xmlFile;
        }

        @Override
        protected Document parseXmlSource() throws IOException, SAXException {
            if (!this.file.exists()) {
                return null;
            }
            return this.getDocumentBuilder().parse(this.file);
        }
    }
}

