/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf;

import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineContext;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineOpcode;
import com.google.firebase.crashlytics.buildtools.utils.io.ByteReader;
import java.io.IOException;

public class SpecialOpcode
implements DebugLineOpcode {
    private final int _opcode;

    public SpecialOpcode(int opcode) {
        this._opcode = opcode;
    }

    @Override
    public boolean process(DebugLineContext context, ByteReader dataReader) throws IOException {
        int adjustedOpcode = this._opcode - context.header.opcodeBase;
        int operationAdvance = adjustedOpcode / context.header.lineRange;
        int addressIncrement = context.header.minInstructionLength * ((context.reg.opIndex + operationAdvance) / context.header.maximumOperationsPerInstruction);
        int lineIncrement = context.header.lineBase + adjustedOpcode % context.header.lineRange;
        int opIndexIncrement = context.reg.opIndex + operationAdvance;
        context.reg.opIndex = opIndexIncrement % context.header.maximumOperationsPerInstruction;
        context.reg.address += (long)addressIncrement;
        context.reg.line += (long)lineIncrement;
        context.reg.isBasicBlock = false;
        return true;
    }
}

