/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRange;
import java.util.List;
import java.util.TreeMap;

public class NamedRanges {
    public TreeMap<Long, NamedRange> _byStartAddress = Maps.newTreeMap();

    public NamedRanges(List<NamedRange> namedRanges) {
        for (NamedRange range : namedRanges) {
            this._byStartAddress.put(range.start, range);
        }
    }

    public Optional<NamedRange> rangeFor(long address) {
        NamedRange closest;
        NamedRange namedRange = closest = this._byStartAddress.containsKey(address) ? this._byStartAddress.get(address) : NamedRanges.findClosest(this._byStartAddress, address);
        if (closest == null) {
            return Optional.absent();
        }
        return closest.contains(address) ? Optional.of((Object)closest) : Optional.absent();
    }

    private static NamedRange findClosest(TreeMap<Long, NamedRange> index, long address) {
        Long prevKey = index.lowerKey(address);
        return prevKey != null ? index.get(prevKey) : null;
    }
}

