/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.crash.zzi;
import com.google.android.gms.internal.crash.zzj;
import com.google.android.gms.internal.crash.zzm;
import com.google.android.gms.internal.crash.zzq;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crash.zze;
import com.google.firebase.crash.zzf;
import com.google.firebase.crash.zzg;
import com.google.firebase.crash.zzh;
import com.google.firebase.events.Event;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.iid.FirebaseInstanceId;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private final AtomicReference<zzd> zzd = new AtomicReference<zzd>(com.google.firebase.crash.FirebaseCrash$zzd.zzu);
    private static volatile FirebaseCrash zze;
    private final Context zzf;
    private final ExecutorService zzg;
    private final FirebaseApp zzh;
    private final zzb zzi = new zzb(null);
    private final CountDownLatch zzj = new CountDownLatch(1);
    private zzq zzk;
    private String zzl;

    public static FirebaseCrash zza() {
        if (zze == null) {
            zze = FirebaseCrash.getInstance(FirebaseApp.getInstance());
        }
        return zze;
    }

    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        return (FirebaseCrash)firebaseApp.get(FirebaseCrash.class);
    }

    @Keep
    public FirebaseCrash(@NonNull FirebaseApp firebaseApp) {
        throw new IllegalStateException("This method shouldn't be invoked");
    }

    public FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull Subscriber subscriber) {
        this(firebaseApp, subscriber, null);
        zzf zzf2 = new zzf(firebaseApp);
        FirebaseCrash firebaseCrash = this;
        Thread.setDefaultUncaughtExceptionHandler(firebaseCrash.new zzc(Thread.getDefaultUncaughtExceptionHandler()));
        zze zze2 = new zze(firebaseCrash);
        zzf zzf3 = zzf2;
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<zzm> future = executorService.submit(new zzg(zzf3));
        executorService.submit(new zzh(zzf3, future, 10000L, zze2));
        executorService.shutdown();
        firebaseCrash.zzg.execute(new com.google.firebase.crash.zzd(firebaseCrash));
    }

    @VisibleForTesting
    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull Subscriber subscriber, @Nullable ExecutorService executorService) {
        this.zzh = firebaseApp;
        this.zzf = firebaseApp.getApplicationContext();
        this.zzd.set(this.zze());
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.zzg = executorService = threadPoolExecutor;
        subscriber.subscribe(DataCollectionDefaultChange.class, com.google.firebase.crash.zza.zzm, (EventHandler)new com.google.firebase.crash.zzb(this));
    }

    final void zza(@Nullable zzm zzm2) {
        if (zzm2 == null) {
            this.zzg.shutdownNow();
        } else {
            zzq zzq2;
            AnalyticsConnector analyticsConnector = (AnalyticsConnector)this.zzh.get(AnalyticsConnector.class);
            if (analyticsConnector == null) {
                Log.w((String)"FirebaseCrashAnalytics", (String)"Unable to log event, missing Google Analytics for Firebase library");
                zzq2 = null;
            } else {
                zzq2 = new zzq(analyticsConnector);
            }
            this.zzk = zzq2;
            this.zzi.zzb(zzm2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzk != null && !firebaseCrash.zzc()) {
                firebaseCrash.zzk.zza(firebaseCrash.zzf, firebaseCrash.zzg, firebaseCrash.zzi);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzj.countDown();
        if (!FirebaseApp.getInstance().isDataCollectionDefaultEnabled()) {
            this.zza(false, false);
        }
    }

    private final void zzb() {
        try {
            this.zzj.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    @VisibleForTesting
    public final boolean zzc() {
        return this.zzg.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zza().zza(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zza();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zza(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zza();
        if (throwable2 == null || firebaseCrash.zzc()) {
            return;
        }
        firebaseCrash.zzg();
        firebaseCrash.zzg.submit(new com.google.android.gms.internal.crash.zze(firebaseCrash.zzf, firebaseCrash.zzi, throwable2, firebaseCrash.zzk));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash.zza().zza(bl, true);
    }

    private final synchronized void zza(boolean bl, boolean bl2) {
        if (this.zzc()) {
            return;
        }
        if (!bl2 && this.zzd.get() != com.google.firebase.crash.FirebaseCrash$zzd.zzu) {
            return;
        }
        zzi zzi2 = new zzi(this.zzf, this.zzi, bl);
        zzi2.getTask().addOnSuccessListener((OnSuccessListener)new com.google.firebase.crash.zzc(this, bl2, bl));
        this.zzg.execute(zzi2);
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zza().zzd();
    }

    @VisibleForTesting
    private final boolean zzd() {
        if (this.zzc()) {
            return false;
        }
        this.zzb();
        zzd zzd2 = this.zzd.get();
        return this.zzi.zzh() != null && (zzd2 != com.google.firebase.crash.FirebaseCrash$zzd.zzu ? zzd2 == com.google.firebase.crash.FirebaseCrash$zzd.zzv : FirebaseApp.getInstance().isDataCollectionDefaultEnabled());
    }

    private final zzd zze() {
        SharedPreferences sharedPreferences = this.zzf.getSharedPreferences("FirebaseCrashSharedPrefs", 0);
        try {
            if (sharedPreferences.contains("firebase_crash_collection_enabled")) {
                if (sharedPreferences.getBoolean("firebase_crash_collection_enabled", false)) {
                    return com.google.firebase.crash.FirebaseCrash$zzd.zzv;
                }
                return com.google.firebase.crash.FirebaseCrash$zzd.zzw;
            }
        }
        catch (ClassCastException classCastException) {
            String string = String.valueOf(classCastException.getMessage());
            Log.d((String)"FirebaseCrash", (String)(string.length() != 0 ? "Unable to access enable value: ".concat(string) : new String("Unable to access enable value: ")));
        }
        Boolean bl = this.zzf();
        if (bl == null) {
            return com.google.firebase.crash.FirebaseCrash$zzd.zzu;
        }
        if (bl.booleanValue()) {
            return com.google.firebase.crash.FirebaseCrash$zzd.zzv;
        }
        return com.google.firebase.crash.FirebaseCrash$zzd.zzw;
    }

    @Nullable
    private final Boolean zzf() {
        try {
            Bundle bundle = this.zzf.getPackageManager().getApplicationInfo((String)this.zzf.getPackageName(), (int)128).metaData;
            if (bundle.containsKey("firebase_crash_collection_enabled")) {
                return bundle.getBoolean("firebase_crash_collection_enabled", false);
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            String string = String.valueOf(throwable.getMessage());
            Log.e((String)"FirebaseCrash", (String)(string.length() != 0 ? "No crash enable meta data found: ".concat(string) : new String("No crash enable meta data found: ")));
        }
        return null;
    }

    private final void zza(String string) {
        if (string == null || this.zzc()) {
            return;
        }
        this.zzg.submit(new com.google.android.gms.internal.crash.zzf(this.zzf, this.zzi, string));
    }

    @Nullable
    final Future<?> zza(Throwable throwable) {
        if (throwable == null || this.zzc()) {
            return null;
        }
        return this.zzg.submit(new com.google.android.gms.internal.crash.zzg(this.zzf, this.zzi, throwable, this.zzk));
    }

    final void zza(boolean bl) {
        if (this.zzc()) {
            return;
        }
        this.zzg.submit(new com.google.android.gms.internal.crash.zzh(this.zzf, this.zzi, bl));
    }

    final void zzg() {
        if (this.zzl != null || this.zzc() || !this.zzd()) {
            return;
        }
        this.zzl = FirebaseInstanceId.getInstance().getId();
        this.zzg.execute(new zzj(this.zzf, this.zzi, this.zzl));
    }

    final /* synthetic */ void zza(boolean bl, boolean bl2, Void void_) {
        if (bl) {
            this.zzd.set(bl2 ? com.google.firebase.crash.FirebaseCrash$zzd.zzv : com.google.firebase.crash.FirebaseCrash$zzd.zzw);
            this.zzf.getSharedPreferences("FirebaseCrashSharedPrefs", 0).edit().putBoolean("firebase_crash_collection_enabled", bl2).apply();
        }
    }

    final /* synthetic */ void zza(Event event) {
        this.zza(((DataCollectionDefaultChange)event.getPayload()).enabled, false);
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzb();
    }

    @VisibleForTesting
    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzt;

        public zzc(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzt = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!FirebaseCrash.this.zzc()) {
                try {
                    FirebaseCrash.this.zzg();
                    Future<?> future = FirebaseCrash.this.zza(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzt != null) {
                this.zzt.uncaughtException(thread, throwable);
            }
        }
    }

    private static final class zzd
    extends Enum<zzd> {
        public static final /* enum */ zzd zzu = new zzd();
        public static final /* enum */ zzd zzv = new zzd();
        public static final /* enum */ zzd zzw = new zzd();
        private static final /* synthetic */ zzd[] zzx;

        public static zzd[] values() {
            return (zzd[])zzx.clone();
        }

        static {
            zzx = new zzd[]{zzu, zzv, zzw};
        }
    }

    private static final class zzb
    implements zza {
        private final Object zzr = new Object();
        private zzm zzs;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzm zzh() {
            Object object = this.zzr;
            synchronized (object) {
                return this.zzs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable zzm zzm2) {
            Object object = this.zzr;
            synchronized (object) {
                this.zzs = zzm2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zzd zzd2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public zzm zzh();
    }
}

