/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.internal.crash.zzm;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.crash.FirebaseCrash;

abstract class zzc
implements Runnable {
    private final FirebaseCrash.zza zzac;
    private final Context zzf;
    private final TaskCompletionSource<Void> zzad;

    zzc(@NonNull Context context, @NonNull FirebaseCrash.zza zza2) {
        this.zzac = zza2;
        this.zzf = context.getApplicationContext();
        this.zzad = new TaskCompletionSource();
    }

    public Task<Void> getTask() {
        return this.zzad.getTask();
    }

    @Override
    public void run() {
        try {
            zzm zzm2 = this.zzac.zzh();
            if (zzm2 == null) {
                throw new IllegalStateException("Firebase Crash api is not available");
            }
            if (!zzm2.zzd() && this.zzk()) {
                throw new IllegalStateException("Firebase Crash reporting is not enabled");
            }
            this.zzd(zzm2);
            this.zzad.setResult(null);
            return;
        }
        catch (RemoteException | RuntimeException throwable) {
            CrashUtils.addDynamiteErrorToDropBox((Context)this.zzf, (Throwable)throwable);
            Log.e((String)"FirebaseCrash", (String)this.getErrorMessage(), (Throwable)throwable);
            this.zzad.setException((Exception)throwable);
            return;
        }
    }

    @NonNull
    protected abstract String getErrorMessage();

    protected boolean zzk() {
        return false;
    }

    protected abstract void zzd(@NonNull zzm var1) throws RemoteException;
}

