/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.json.JSONObject;

@AnyThread
public class ConfigStorageClient {
    @GuardedBy(value="ConfigStorageClient.class")
    private static final Map<String, ConfigStorageClient> clientInstances = new HashMap<String, ConfigStorageClient>();
    private static final String JSON_STRING_ENCODING = "UTF-8";
    private final Context context;
    private final String fileName;

    private ConfigStorageClient(Context context, String fileName) {
        this.context = context;
        this.fileName = fileName;
    }

    public synchronized Void write(ConfigContainer container) throws IOException {
        try (FileOutputStream outputStream = this.context.openFileOutput(this.fileName, 0);){
            outputStream.write(container.toString().getBytes(JSON_STRING_ENCODING));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized ConfigContainer read() throws IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = this.context.openFileInput(this.fileName);
            byte[] bytes = new byte[fileInputStream.available()];
            fileInputStream.read(bytes, 0, bytes.length);
            String containerJsonString = new String(bytes, JSON_STRING_ENCODING);
            JSONObject containerJson = new JSONObject(containerJsonString);
            ConfigContainer configContainer = ConfigContainer.copyOf(containerJson);
            return configContainer;
        }
    }

    public synchronized Void clear() {
        this.context.deleteFile(this.fileName);
        return null;
    }

    public static synchronized ConfigStorageClient getInstance(Context context, String fileName) {
        if (!clientInstances.containsKey(fileName)) {
            clientInstances.put(fileName, new ConfigStorageClient(context, fileName));
        }
        return clientInstances.get(fileName);
    }

    @VisibleForTesting
    public static synchronized void clearInstancesForTest() {
        clientInstances.clear();
    }

    String getFileName() {
        return this.fileName;
    }
}

