/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.config.zzal;
import com.google.android.gms.internal.config.zzam;
import com.google.android.gms.internal.config.zzan;
import com.google.android.gms.internal.config.zzao;
import com.google.android.gms.internal.config.zzap;
import com.google.android.gms.internal.config.zzaq;
import com.google.android.gms.internal.config.zzar;
import com.google.android.gms.internal.config.zzas;
import com.google.android.gms.internal.config.zzau;
import com.google.android.gms.internal.config.zzav;
import com.google.android.gms.internal.config.zzaw;
import com.google.android.gms.internal.config.zzay;
import com.google.android.gms.internal.config.zzbh;
import com.google.android.gms.internal.config.zze;
import com.google.android.gms.internal.config.zzi;
import com.google.android.gms.internal.config.zzj;
import com.google.android.gms.internal.config.zzk;
import com.google.android.gms.internal.config.zzv;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    @GuardedBy(value="FirebaseRemoteConfig.class")
    private static FirebaseRemoteConfig zzag;
    private zzan zzah;
    private zzan zzai;
    private zzan zzaj;
    private zzaq zzak;
    private final Context mContext;
    private final FirebaseApp zzal;
    private final ReadWriteLock zzam = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context, @Nullable zzan zzan2, @Nullable zzan zzan3, @Nullable zzan zzan4, @Nullable zzaq zzaq2) {
        this.mContext = context;
        this.zzak = zzaq2 == null ? new zzaq() : zzaq2;
        this.zzak.zzc(this.zzd(this.mContext));
        this.zzah = zzan2;
        this.zzai = zzan3;
        this.zzaj = zzan4;
        this.zzal = FirebaseApp.initializeApp((Context)this.mContext);
    }

    public static FirebaseRemoteConfig getInstance() {
        return FirebaseRemoteConfig.zzc(FirebaseApp.getInstance().getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ShowFirstParty
    private static FirebaseRemoteConfig zzc(Context context) {
        Class<FirebaseRemoteConfig> clazz = FirebaseRemoteConfig.class;
        synchronized (FirebaseRemoteConfig.class) {
            if (zzag == null) {
                zzan zzan2 = null;
                zzan zzan3 = null;
                zzan zzan4 = null;
                Object object = null;
                zzav zzav2 = FirebaseRemoteConfig.zze(context);
                if (zzav2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                } else {
                    Object object2;
                    Object object3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzan2 = FirebaseRemoteConfig.zza(zzav2.zzbp);
                    zzan3 = FirebaseRemoteConfig.zza(zzav2.zzbq);
                    zzan4 = FirebaseRemoteConfig.zza(zzav2.zzbr);
                    zzaw[] zzawArray = zzav2.zzbs;
                    if (zzav2.zzbs == null) {
                        object3 = null;
                    } else {
                        object2 = new zzaq();
                        ((zzaq)object2).zzf(zzawArray.zzbj);
                        ((zzaq)object2).zza(zzawArray.zzbk);
                        object3 = object = object2;
                    }
                    if (object3 != null) {
                        zzawArray = zzav2.zzbt;
                        object2 = new HashMap();
                        if (zzawArray != null) {
                            zzaw[] zzawArray2 = zzawArray;
                            int n = zzawArray.length;
                            for (int i = 0; i < n; ++i) {
                                zzaw zzaw2 = zzawArray2[i];
                                String string = zzaw2.zzbn;
                                int n2 = zzaw2.resourceId;
                                long l = zzaw2.zzbv;
                                object2.put(string, new zzal(n2, l));
                            }
                        }
                        ((zzaq)object).zza((Map<String, zzal>)object2);
                    }
                }
                zzag = new FirebaseRemoteConfig(context, zzan2, zzan3, zzan4, (zzaq)object);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzag;
        }
    }

    private final long zzd(Context context) {
        long l = 0L;
        try {
            l = Wrappers.packageManager((Context)this.mContext).getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzav zze(Context context) {
        zzav zzav2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream;
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
            FileInputStream fileInputStream2 = object;
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)fileInputStream2).read(byArray)) != -1) {
                ((OutputStream)byteArrayOutputStream2).write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            object = byArray2;
            zzay zzay2 = zzay.zza(byArray2, 0, ((Object)object).length);
            zzav2 = new zzav();
            ((zzbh)zzav2).zza(zzay2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzav2;
    }

    private static zzan zza(zzar zzar2) {
        Object object;
        if (zzar2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzar2.zzbe;
        int n = zzar2.zzbe.length;
        for (int i = 0; i < n; ++i) {
            zzau zzau2 = object2[i];
            String string = zzau2.zzbn;
            object = new HashMap();
            zzas[] zzasArray = zzau2.zzbo;
            int n2 = zzau2.zzbo.length;
            for (int j = 0; j < n2; ++j) {
                zzas zzas2 = zzasArray[j];
                object.put(zzas2.zzbh, zzas2.zzbi);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzar2.zzbf;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzau[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzan(hashMap, zzar2.timestamp, arrayList);
    }

    public boolean activateFetched() {
        this.zzam.writeLock().lock();
        try {
            if (this.zzah == null) {
                return false;
            }
            if (this.zzai != null && this.zzah.getTimestamp() <= this.zzai.getTimestamp()) {
                return false;
            }
            long l = this.zzah.getTimestamp();
            this.zzai = this.zzah;
            this.zzai.setTimestamp(System.currentTimeMillis());
            this.zzah = new zzan(null, l, null);
            this.zzo();
            return true;
        }
        finally {
            this.zzam.writeLock().unlock();
        }
    }

    @KeepForSdk
    public boolean activateFetched(String string) {
        this.zzam.writeLock().lock();
        try {
            Map<String, byte[]> map;
            if (this.zzah == null) {
                return false;
            }
            if (this.zzai != null && this.zzah.getTimestamp() <= this.zzai.getTimestamp()) {
                return false;
            }
            if (this.zzai == null) {
                this.zzai = new zzan(null, 0L, null);
            }
            if ((map = this.zzah.zzc(string)) == null) {
                return false;
            }
            this.zzai.zza(map, string);
            this.zzo();
            return true;
        }
        finally {
            this.zzam.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzam.readLock().lock();
        try {
            if (this.zzak != null && this.zzak.zzs() != null && this.zzak.zzs().get(string) != null && n == ((zzal)(object = this.zzak.zzs().get(string))).getResourceId() && this.zzak.zzt() == ((zzal)object).zzp()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzam.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzal zzal2 = new zzal(n, this.zzak.zzt());
            this.zzak.zza(string, zzal2);
            this.zza((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zza(map, string, true);
    }

    private final void zza(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzap.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzap.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzap.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzap.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzap.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzap.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzam.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzaj == null || !this.zzaj.zzb(string)) {
                    return;
                }
                this.zzaj.zza(null, string);
                this.zzaj.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzaj == null) {
                    this.zzaj = new zzan(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzaj.zza(hashMap, string);
                this.zzaj.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzak.zzd(string);
            }
            this.zzo();
            return;
        }
        finally {
            this.zzam.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzam.writeLock().lock();
        try {
            boolean bl = this.zzak.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzak.zza(bl2);
            if (bl != bl2) {
                this.zzo();
            }
            return;
        }
        finally {
            this.zzam.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzam.readLock().lock();
        try {
            if (this.zzai != null && this.zzai.zzb(string, string2)) {
                byte[] byArray = this.zzai.zzc(string, string2);
                return byArray;
            }
            if (this.zzaj != null && this.zzaj.zzb(string, string2)) {
                byte[] byArray = this.zzaj.zzc(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzam.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_STRING;
        }
        this.zzam.readLock().lock();
        try {
            if (this.zzai != null && this.zzai.zzb(string, string2)) {
                String string3 = new String(this.zzai.zzc(string, string2), zzap.UTF_8);
                return string3;
            }
            if (this.zzaj != null && this.zzaj.zzb(string, string2)) {
                String string4 = new String(this.zzaj.zzc(string, string2), zzap.UTF_8);
                return string4;
            }
            String string5 = DEFAULT_VALUE_FOR_STRING;
            return string5;
        }
        finally {
            this.zzam.readLock().unlock();
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzam.readLock().lock();
        try {
            String string3;
            if (this.zzai != null && this.zzai.zzb(string, string2)) {
                string3 = new String(this.zzai.zzc(string, string2), zzap.UTF_8);
                if (zzap.zzm.matcher(string3).matches()) {
                    return true;
                }
                if (zzap.zzn.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzaj != null && this.zzaj.zzb(string, string2)) {
                string3 = new String(this.zzaj.zzc(string, string2), zzap.UTF_8);
                if (zzap.zzm.matcher(string3).matches()) {
                    return true;
                }
                if (zzap.zzn.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzam.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzap(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzam.readLock().lock();
        try {
            if (this.zzai != null && this.zzai.zzb(string, string2)) {
                zzap zzap2 = new zzap(this.zzai.zzc(string, string2), 2);
                return zzap2;
            }
            if (this.zzaj != null && this.zzaj.zzb(string, string2)) {
                zzap zzap3 = new zzap(this.zzaj.zzc(string, string2), 1);
                return zzap3;
            }
            zzap zzap4 = new zzap(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzap4;
        }
        finally {
            this.zzam.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzao zzao2 = new zzao();
        this.zzam.readLock().lock();
        try {
            long l = this.zzah == null ? -1L : this.zzah.getTimestamp();
            zzao2.zzb(l);
            zzao2.zzf(this.zzak.getLastFetchStatus());
            zzao2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzak.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzam.readLock().unlock();
        }
        return zzao2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzam.readLock().lock();
        try {
            TreeSet<String> treeSet = new TreeSet<String>();
            if (this.zzai != null) {
                treeSet.addAll(this.zzai.zzd(string, string2));
            }
            if (this.zzaj != null) {
                treeSet.addAll(this.zzaj.zzd(string, string2));
            }
            TreeSet<String> treeSet2 = treeSet;
            return treeSet2;
        }
        finally {
            this.zzam.readLock().unlock();
        }
    }

    private final void zzo() {
        this.zzam.readLock().lock();
        try {
            zzam zzam2 = new zzam(this.mContext, this.zzah, this.zzai, this.zzaj, this.zzak);
            AsyncTask.SERIAL_EXECUTOR.execute(zzam2);
            return;
        }
        finally {
            this.zzam.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        return this.zza(l, new zzv(this.mContext));
    }

    @VisibleForTesting
    private final Task<Void> zza(long l, zzv zzv2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzam.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzj zzj2 = new zzj();
            zzj2.zza(l);
            if (this.zzal != null) {
                zzj2.zza(this.zzal.getOptions().getApplicationId());
            }
            if (this.zzak.isDeveloperModeEnabled()) {
                zzj2.zza("_rcn_developer", "true");
            }
            zzj2.zza(10300);
            if (this.zzai != null && this.zzai.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzai.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzj2.zzc(n);
            }
            if (this.zzah != null && this.zzah.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzah.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzj2.zzb(n);
            }
            zzi zzi2 = zzj2.zzg();
            zzv zzv3 = zzv2;
            zze.zzf.zza(zzv3.asGoogleApiClient(), zzi2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzam.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzk zzk2) {
        if (zzk2 == null || zzk2.getStatus() == null) {
            this.zza(taskCompletionSource, (Status)null);
            return;
        }
        int n = zzk2.getStatus().getStatusCode();
        this.zzam.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zza(taskCompletionSource, zzk2.getStatus());
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzak.zzf(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzk2.getThrottleEndTimeMillis())));
                    this.zzo();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzak.zzf(-1);
                    if (this.zzah != null && !this.zzah.zzr()) {
                        Map<String, Set<String>> map = zzk2.zzi();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzk2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzah = new zzan(hashMap, this.zzah.getTimestamp(), zzk2.zzh());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzo();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzk2.zzi();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzk2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzah = new zzan(hashMap, System.currentTimeMillis(), zzk2.zzh());
                    this.zzak.zzf(-1);
                    taskCompletionSource.setResult(null);
                    this.zzo();
                    return;
                }
                default: {
                    if (zzk2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zza(taskCompletionSource, zzk2.getStatus());
                    return;
                }
            }
        }
        finally {
            this.zzam.writeLock().unlock();
        }
    }

    private final void zza(TaskCompletionSource<Void> taskCompletionSource, Status status) {
        if (status == null) {
            Log.w((String)"FirebaseRemoteConfig", (String)"Received null IPC status for failure.");
        } else {
            int n = status.getStatusCode();
            String string = status.getStatusMessage();
            Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("IPC failure: ").append(n).append(":").append(string).toString());
        }
        this.zzam.writeLock().lock();
        try {
            this.zzak.zzf(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzo();
            return;
        }
        finally {
            this.zzam.writeLock().unlock();
        }
    }
}

