/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.interop.rollouts;

import androidx.annotation.NonNull;
import com.google.firebase.remoteconfig.interop.rollouts.RolloutAssignment;

final class AutoValue_RolloutAssignment
extends RolloutAssignment {
    private final String rolloutId;
    private final String variantId;
    private final String parameterKey;
    private final String parameterValue;
    private final long templateVersion;

    private AutoValue_RolloutAssignment(String rolloutId, String variantId, String parameterKey, String parameterValue, long templateVersion) {
        this.rolloutId = rolloutId;
        this.variantId = variantId;
        this.parameterKey = parameterKey;
        this.parameterValue = parameterValue;
        this.templateVersion = templateVersion;
    }

    @Override
    @NonNull
    public String getRolloutId() {
        return this.rolloutId;
    }

    @Override
    @NonNull
    public String getVariantId() {
        return this.variantId;
    }

    @Override
    @NonNull
    public String getParameterKey() {
        return this.parameterKey;
    }

    @Override
    @NonNull
    public String getParameterValue() {
        return this.parameterValue;
    }

    @Override
    public long getTemplateVersion() {
        return this.templateVersion;
    }

    public String toString() {
        return "RolloutAssignment{rolloutId=" + this.rolloutId + ", variantId=" + this.variantId + ", parameterKey=" + this.parameterKey + ", parameterValue=" + this.parameterValue + ", templateVersion=" + this.templateVersion + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RolloutAssignment) {
            RolloutAssignment that = (RolloutAssignment)o;
            return this.rolloutId.equals(that.getRolloutId()) && this.variantId.equals(that.getVariantId()) && this.parameterKey.equals(that.getParameterKey()) && this.parameterValue.equals(that.getParameterValue()) && this.templateVersion == that.getTemplateVersion();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.rolloutId.hashCode();
        h$ *= 1000003;
        h$ ^= this.variantId.hashCode();
        h$ *= 1000003;
        h$ ^= this.parameterKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.parameterValue.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.templateVersion >>> 32 ^ this.templateVersion);
    }

    static final class Builder
    extends RolloutAssignment.Builder {
        private String rolloutId;
        private String variantId;
        private String parameterKey;
        private String parameterValue;
        private long templateVersion;
        private byte set$0;

        Builder() {
        }

        @Override
        public RolloutAssignment.Builder setRolloutId(String rolloutId) {
            if (rolloutId == null) {
                throw new NullPointerException("Null rolloutId");
            }
            this.rolloutId = rolloutId;
            return this;
        }

        @Override
        public RolloutAssignment.Builder setVariantId(String variantId) {
            if (variantId == null) {
                throw new NullPointerException("Null variantId");
            }
            this.variantId = variantId;
            return this;
        }

        @Override
        public RolloutAssignment.Builder setParameterKey(String parameterKey) {
            if (parameterKey == null) {
                throw new NullPointerException("Null parameterKey");
            }
            this.parameterKey = parameterKey;
            return this;
        }

        @Override
        public RolloutAssignment.Builder setParameterValue(String parameterValue) {
            if (parameterValue == null) {
                throw new NullPointerException("Null parameterValue");
            }
            this.parameterValue = parameterValue;
            return this;
        }

        @Override
        public RolloutAssignment.Builder setTemplateVersion(long templateVersion) {
            this.templateVersion = templateVersion;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public RolloutAssignment build() {
            if (this.set$0 != 1 || this.rolloutId == null || this.variantId == null || this.parameterKey == null || this.parameterValue == null) {
                StringBuilder missing = new StringBuilder();
                if (this.rolloutId == null) {
                    missing.append(" rolloutId");
                }
                if (this.variantId == null) {
                    missing.append(" variantId");
                }
                if (this.parameterKey == null) {
                    missing.append(" parameterKey");
                }
                if (this.parameterValue == null) {
                    missing.append(" parameterValue");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" templateVersion");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RolloutAssignment(this.rolloutId, this.variantId, this.parameterKey, this.parameterValue, this.templateVersion);
        }
    }
}

