/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzv;

public final class FirebaseOptions {
    private final String aWg;
    private final String lU;
    private final String aWh;
    private final String aWi;
    private final String aWj;
    private final String aWk;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        zzaa.zza((!zzv.zzij((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.lU = string;
        this.aWg = string2;
        this.aWh = string3;
        this.aWi = string4;
        this.aWj = string5;
        this.aWk = string6;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzah zzah2 = new zzah(context);
        String string = zzah2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzah2.getString("google_api_key"), zzah2.getString("firebase_database_url"), zzah2.getString("ga_trackingId"), zzah2.getString("gcm_defaultSenderId"), zzah2.getString("google_storage_bucket"));
    }

    public String getApiKey() {
        return this.aWg;
    }

    public String getApplicationId() {
        return this.lU;
    }

    public String getDatabaseUrl() {
        return this.aWh;
    }

    public String getGcmSenderId() {
        return this.aWj;
    }

    public String getStorageBucket() {
        return this.aWk;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzz.equal((Object)this.lU, (Object)firebaseOptions.lU) && zzz.equal((Object)this.aWg, (Object)firebaseOptions.aWg) && zzz.equal((Object)this.aWh, (Object)firebaseOptions.aWh) && zzz.equal((Object)this.aWi, (Object)firebaseOptions.aWi) && zzz.equal((Object)this.aWj, (Object)firebaseOptions.aWj) && zzz.equal((Object)this.aWk, (Object)firebaseOptions.aWk);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.lU, this.aWg, this.aWh, this.aWi, this.aWj, this.aWk});
    }

    public String toString() {
        return zzz.zzx((Object)this).zzg("applicationId", (Object)this.lU).zzg("apiKey", (Object)this.aWg).zzg("databaseUrl", (Object)this.aWh).zzg("gcmSenderId", (Object)this.aWj).zzg("storageBucket", (Object)this.aWk).toString();
    }

    public static final class Builder {
        private String aWg;
        private String lU;
        private String aWh;
        private String aWi;
        private String aWj;
        private String aWk;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.lU = firebaseOptions.lU;
            this.aWg = firebaseOptions.aWg;
            this.aWh = firebaseOptions.aWh;
            this.aWi = firebaseOptions.aWi;
            this.aWj = firebaseOptions.aWj;
            this.aWk = firebaseOptions.aWk;
        }

        public Builder setApiKey(@NonNull String string) {
            this.aWg = zzaa.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public Builder setApplicationId(@NonNull String string) {
            this.lU = zzaa.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public Builder setDatabaseUrl(@Nullable String string) {
            this.aWh = string;
            return this;
        }

        public Builder setGcmSenderId(@Nullable String string) {
            this.aWj = string;
            return this;
        }

        public Builder setStorageBucket(@Nullable String string) {
            this.aWk = string;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.lU, this.aWg, this.aWh, this.aWi, this.aWj, this.aWk);
        }
    }
}

