/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzaj;
import com.google.android.gms.common.util.zzw;

public final class FirebaseOptions {
    private final String yQ;
    private final String jM;
    private final String aSU;
    private final String aSV;
    private final String yT;
    private final String yU;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        zzac.zza((!zzw.zzij((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.jM = string;
        this.yQ = string2;
        this.aSU = string3;
        this.aSV = string4;
        this.yT = string5;
        this.yU = string6;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzaj zzaj2 = new zzaj(context);
        String string = zzaj2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzaj2.getString("google_api_key"), zzaj2.getString("firebase_database_url"), zzaj2.getString("ga_trackingId"), zzaj2.getString("gcm_defaultSenderId"), zzaj2.getString("google_storage_bucket"));
    }

    public String getApiKey() {
        return this.yQ;
    }

    public String getApplicationId() {
        return this.jM;
    }

    public String getDatabaseUrl() {
        return this.aSU;
    }

    public String getGcmSenderId() {
        return this.yT;
    }

    public String getStorageBucket() {
        return this.yU;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzab.equal((Object)this.jM, (Object)firebaseOptions.jM) && zzab.equal((Object)this.yQ, (Object)firebaseOptions.yQ) && zzab.equal((Object)this.aSU, (Object)firebaseOptions.aSU) && zzab.equal((Object)this.aSV, (Object)firebaseOptions.aSV) && zzab.equal((Object)this.yT, (Object)firebaseOptions.yT) && zzab.equal((Object)this.yU, (Object)firebaseOptions.yU);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.jM, this.yQ, this.aSU, this.aSV, this.yT, this.yU});
    }

    public String toString() {
        return zzab.zzx((Object)this).zzg("applicationId", (Object)this.jM).zzg("apiKey", (Object)this.yQ).zzg("databaseUrl", (Object)this.aSU).zzg("gcmSenderId", (Object)this.yT).zzg("storageBucket", (Object)this.yU).toString();
    }

    public static final class Builder {
        private String yQ;
        private String jM;
        private String aSU;
        private String aSV;
        private String yT;
        private String yU;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.jM = firebaseOptions.jM;
            this.yQ = firebaseOptions.yQ;
            this.aSU = firebaseOptions.aSU;
            this.aSV = firebaseOptions.aSV;
            this.yT = firebaseOptions.yT;
            this.yU = firebaseOptions.yU;
        }

        public Builder setApiKey(@NonNull String string) {
            this.yQ = zzac.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public Builder setApplicationId(@NonNull String string) {
            this.jM = zzac.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public Builder setDatabaseUrl(@Nullable String string) {
            this.aSU = string;
            return this;
        }

        public Builder setGcmSenderId(@Nullable String string) {
            this.yT = string;
            return this;
        }

        public Builder setStorageBucket(@Nullable String string) {
            this.yU = string;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.jM, this.yQ, this.aSU, this.aSV, this.yT, this.yU);
        }
    }
}

