/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzai;
import com.google.android.gms.common.util.zzw;

public final class FirebaseOptions {
    private final String uS;
    private final String gs;
    private final String aMW;
    private final String aMX;
    private final String uV;
    private final String uW;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        zzab.zza((!zzw.zzic((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.gs = string;
        this.uS = string2;
        this.aMW = string3;
        this.aMX = string4;
        this.uV = string5;
        this.uW = string6;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzai zzai2 = new zzai(context);
        String string = zzai2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzai2.getString("google_api_key"), zzai2.getString("firebase_database_url"), zzai2.getString("ga_trackingId"), zzai2.getString("gcm_defaultSenderId"), zzai2.getString("google_storage_bucket"));
    }

    public String getApiKey() {
        return this.uS;
    }

    public String getApplicationId() {
        return this.gs;
    }

    public String getDatabaseUrl() {
        return this.aMW;
    }

    public String getGcmSenderId() {
        return this.uV;
    }

    public String getStorageBucket() {
        return this.uW;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzaa.equal((Object)this.gs, (Object)firebaseOptions.gs) && zzaa.equal((Object)this.uS, (Object)firebaseOptions.uS) && zzaa.equal((Object)this.aMW, (Object)firebaseOptions.aMW) && zzaa.equal((Object)this.aMX, (Object)firebaseOptions.aMX) && zzaa.equal((Object)this.uV, (Object)firebaseOptions.uV) && zzaa.equal((Object)this.uW, (Object)firebaseOptions.uW);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.gs, this.uS, this.aMW, this.aMX, this.uV, this.uW});
    }

    public String toString() {
        return zzaa.zzz((Object)this).zzg("applicationId", (Object)this.gs).zzg("apiKey", (Object)this.uS).zzg("databaseUrl", (Object)this.aMW).zzg("gcmSenderId", (Object)this.uV).zzg("storageBucket", (Object)this.uW).toString();
    }

    public static final class Builder {
        private String uS;
        private String gs;
        private String aMW;
        private String aMX;
        private String uV;
        private String uW;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.gs = firebaseOptions.gs;
            this.uS = firebaseOptions.uS;
            this.aMW = firebaseOptions.aMW;
            this.aMX = firebaseOptions.aMX;
            this.uV = firebaseOptions.uV;
            this.uW = firebaseOptions.uW;
        }

        public Builder setApiKey(@NonNull String string) {
            this.uS = zzab.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public Builder setApplicationId(@NonNull String string) {
            this.gs = zzab.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public Builder setDatabaseUrl(@Nullable String string) {
            this.aMW = string;
            return this;
        }

        public Builder setGcmSenderId(@Nullable String string) {
            this.uV = string;
            return this;
        }

        public Builder setStorageBucket(@Nullable String string) {
            this.uW = string;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.gs, this.uS, this.aMW, this.aMX, this.uV, this.uW);
        }
    }
}

