/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.concurrent;

import android.os.Process;
import android.os.StrictMode;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

class CustomThreadFactory
implements ThreadFactory {
    private static final ThreadFactory DEFAULT = Executors.defaultThreadFactory();
    private final AtomicLong threadCount = new AtomicLong();
    private final String namePrefix;
    private final int priority;
    private final StrictMode.ThreadPolicy policy;

    CustomThreadFactory(String namePrefix, int priority, @Nullable StrictMode.ThreadPolicy policy) {
        this.namePrefix = namePrefix;
        this.priority = priority;
        this.policy = policy;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = DEFAULT.newThread(() -> {
            Process.setThreadPriority((int)this.priority);
            if (this.policy != null) {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)this.policy);
            }
            r.run();
        });
        thread.setName(String.format(Locale.ROOT, "%s Thread #%d", this.namePrefix, this.threadCount.getAndIncrement()));
        return thread;
    }
}

