/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.AutomaticDataCollectionChange;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.zzc;
import com.google.firebase.components.zzd;
import com.google.firebase.events.Event;
import com.google.firebase.events.Publisher;
import com.google.firebase.internal.InternalTokenProvider;
import com.google.firebase.internal.InternalTokenResult;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzb = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzc = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzd = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zze = Arrays.asList(new String[0]);
    private static final Set<String> zzf = Collections.emptySet();
    private static final Object zzg = new Object();
    private static final Executor zzh = new zza(0);
    @GuardedBy(value="LOCK")
    static final Map<String, FirebaseApp> zza = new ArrayMap();
    private final Context zzi;
    private final String zzj;
    private final FirebaseOptions zzk;
    private final zzd zzl;
    private final SharedPreferences zzm;
    private final Publisher zzn;
    private final AtomicBoolean zzo = new AtomicBoolean(false);
    private final AtomicBoolean zzp = new AtomicBoolean();
    private final AtomicBoolean zzq;
    private final List<IdTokenListener> zzr = new CopyOnWriteArrayList<IdTokenListener>();
    private final List<BackgroundStateChangeListener> zzs = new CopyOnWriteArrayList<BackgroundStateChangeListener>();
    private final List<com.google.firebase.zza> zzt = new CopyOnWriteArrayList<com.google.firebase.zza>();
    private InternalTokenProvider zzu;
    private IdTokenListenersCountChangedListener zzv;

    @NonNull
    public Context getApplicationContext() {
        this.zzc();
        return this.zzi;
    }

    @NonNull
    public String getName() {
        this.zzc();
        return this.zzj;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzc();
        return this.zzk;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof FirebaseApp)) {
            return false;
        }
        return this.zzj.equals(((FirebaseApp)var1_1).getName());
    }

    public int hashCode() {
        return this.zzj.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.zzj).add("options", (Object)this.zzk).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        Object object = zzg;
        synchronized (object) {
            return new ArrayList<FirebaseApp>(zza.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zzg;
        synchronized (object) {
            FirebaseApp firebaseApp = zza.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                throw new IllegalStateException("Default FirebaseApp is not initialized in this process " + ProcessUtils.getMyProcessName() + ". Make sure to call FirebaseApp.initializeApp(Context) first.");
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String name) {
        Object object = zzg;
        synchronized (object) {
            String string;
            List<String> list = name;
            list = zza.get(((String)((Object)list)).trim());
            if (list != null) {
                return list;
            }
            list = FirebaseApp.zzd();
            list = list.isEmpty() ? "" : "Available app names: " + TextUtils.join((CharSequence)", ", (Iterable)list);
            string = String.format("FirebaseApp with name %s doesn't exist. %s", string, list);
            throw new IllegalStateException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zzg;
        synchronized (object) {
            Context context2;
            if (zza.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context2, firebaseOptions);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions options) {
        void var1_1;
        return FirebaseApp.initializeApp(context, (FirebaseOptions)var1_1, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions options, String name) {
        Object object;
        String string;
        Object object2 = context;
        if (PlatformVersion.isAtLeastIceCreamSandwich() && object2.getApplicationContext() instanceof Application) {
            object2 = (Application)object2.getApplicationContext();
            BackgroundDetector.initialize((Application)object2);
            BackgroundDetector.getInstance().addListener(new BackgroundDetector.BackgroundStateChangeListener(){

                public final void onBackgroundStateChanged(boolean background) {
                    FirebaseApp.onBackgroundStateChanged(background);
                }
            });
        }
        string = string.trim();
        object = context.getApplicationContext() == null ? context : object.getApplicationContext();
        object2 = zzg;
        synchronized (object2) {
            void var1_2;
            Preconditions.checkState((!zza.containsKey(string) ? 1 : 0) != 0, (Object)("FirebaseApp name " + string + " already exists!"));
            Preconditions.checkNotNull((Object)object, (Object)"Application context cannot be null.");
            object = new FirebaseApp((Context)object, string, (FirebaseOptions)var1_2);
            zza.put(string, (FirebaseApp)object);
        }
        super.zze();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onBackgroundStateChanged(boolean background) {
        Object object = zzg;
        synchronized (object) {
            for (FirebaseApp firebaseApp : new ArrayList<FirebaseApp>(zza.values())) {
                if (!firebaseApp.zzo.get()) continue;
                firebaseApp.zza(background);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTokenProvider(@NonNull InternalTokenProvider tokenProvider) {
        void var1_1;
        this.zzu = (InternalTokenProvider)Preconditions.checkNotNull((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIdTokenListenersCountChangedListener(@NonNull IdTokenListenersCountChangedListener listener) {
        void var1_1;
        this.zzv = (IdTokenListenersCountChangedListener)Preconditions.checkNotNull((Object)var1_1);
        this.zzv.onListenerCountChanged(this.zzr.size());
    }

    /*
     * WARNING - void declaration
     */
    public Task<GetTokenResult> getToken(boolean forceRefresh) {
        void var1_1;
        this.zzc();
        if (this.zzu == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzu.getAccessToken((boolean)var1_1);
    }

    @Nullable
    public String getUid() throws FirebaseApiNotAvailableException {
        this.zzc();
        if (this.zzu == null) {
            throw new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode.");
        }
        return this.zzu.getUid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        boolean bl = this.zzp.compareAndSet(false, true);
        if (!bl) {
            return;
        }
        Iterator<com.google.firebase.zza> iterator = zzg;
        synchronized (iterator) {
            zza.remove(this.zzj);
        }
        iterator = this;
        iterator = ((FirebaseApp)((Object)iterator)).zzt.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T get(Class<T> anInterface) {
        void var1_1;
        this.zzc();
        return (T)this.zzl.get((Class)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAutomaticResourceManagementEnabled(boolean enabled) {
        this.zzc();
        boolean bl = this.zzo.compareAndSet(!enabled, enabled);
        if (bl) {
            void var1_1;
            bl = BackgroundDetector.getInstance().isInBackground();
            if (enabled && bl) {
                this.zza(true);
                return;
            }
            if (var1_1 == false && bl) {
                this.zza(false);
            }
        }
    }

    public boolean isAutomaticDataCollectionEnabled() {
        this.zzc();
        return this.zzq.get();
    }

    /*
     * WARNING - void declaration
     */
    public void setAutomaticDataCollectionEnabled(boolean enabled) {
        this.zzc();
        if (this.zzq.compareAndSet(!enabled, enabled)) {
            void var1_1;
            this.zzm.edit().putBoolean("firebase_automatic_data_collection_enabled", enabled).commit();
            this.zzn.publish(new Event<AutomaticDataCollectionChange>(AutomaticDataCollectionChange.class, new AutomaticDataCollectionChange((boolean)var1_1)));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected FirebaseApp(Context applicationContext, String name, FirebaseOptions options) {
        void var3_3;
        void var1_1;
        List<ComponentRegistrar> list;
        this.zzi = (Context)Preconditions.checkNotNull((Object)applicationContext);
        this.zzj = Preconditions.checkNotEmpty((String)((Object)list));
        this.zzk = (FirebaseOptions)Preconditions.checkNotNull((Object)options);
        this.zzv = new com.google.firebase.internal.zza();
        this.zzm = applicationContext.getSharedPreferences("com.google.firebase.common.prefs", 0);
        this.zzq = new AtomicBoolean(this.zzb());
        list = new zzc(applicationContext).zza();
        this.zzl = new zzd(zzh, list, Component.of(var1_1, Context.class, new Class[0]), Component.of(this, FirebaseApp.class, new Class[0]), Component.of(var3_3, FirebaseOptions.class, new Class[0]));
        this.zzn = (Publisher)this.zzl.get(Publisher.class);
    }

    private boolean zzb() {
        if (this.zzm.contains("firebase_automatic_data_collection_enabled")) {
            return this.zzm.getBoolean("firebase_automatic_data_collection_enabled", true);
        }
        try {
            PackageManager packageManager = this.zzi.getPackageManager();
            if (packageManager != null && (packageManager = packageManager.getApplicationInfo(this.zzi.getPackageName(), 128)) != null && packageManager.metaData != null && packageManager.metaData.containsKey("firebase_automatic_data_collection_enabled")) {
                return packageManager.metaData.getBoolean("firebase_automatic_data_collection_enabled");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return true;
    }

    private void zzc() {
        Preconditions.checkState((!this.zzp.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public List<IdTokenListener> getListeners() {
        this.zzc();
        return this.zzr;
    }

    @VisibleForTesting
    public boolean isDefaultApp() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public void notifyIdTokenListeners(@NonNull InternalTokenResult tokenResult) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        for (IdTokenListener idTokenListener : this.zzr) {
            idTokenListener.onIdTokenChanged(tokenResult);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private void zza(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        for (BackgroundStateChangeListener backgroundStateChangeListener : this.zzs) {
            backgroundStateChangeListener.onBackgroundStateChanged(bl);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addIdTokenListener(@NonNull IdTokenListener listener) {
        void var1_1;
        this.zzc();
        Preconditions.checkNotNull((Object)listener);
        this.zzr.add((IdTokenListener)var1_1);
        this.zzv.onListenerCountChanged(this.zzr.size());
    }

    /*
     * WARNING - void declaration
     */
    public void removeIdTokenListener(@NonNull IdTokenListener listenerToRemove) {
        void var1_1;
        this.zzc();
        Preconditions.checkNotNull((Object)listenerToRemove);
        this.zzr.remove(var1_1);
        this.zzv.onListenerCountChanged(this.zzr.size());
    }

    /*
     * WARNING - void declaration
     */
    public void addBackgroundStateChangeListener(BackgroundStateChangeListener listener) {
        void var1_1;
        this.zzc();
        if (this.zzo.get() && BackgroundDetector.getInstance().isInBackground()) {
            listener.onBackgroundStateChanged(true);
        }
        this.zzs.add((BackgroundStateChangeListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeBackgroundStateChangeListener(BackgroundStateChangeListener listener) {
        void var1_1;
        this.zzc();
        this.zzs.remove(var1_1);
    }

    public String getPersistenceKey() {
        return Base64Utils.encodeUrlSafeNoPadding((byte[])this.getName().getBytes()) + "+" + Base64Utils.encodeUrlSafeNoPadding((byte[])this.getOptions().getApplicationId().getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public void addLifecycleEventListener(@NonNull com.google.firebase.zza listener) {
        void var1_1;
        this.zzc();
        Preconditions.checkNotNull((Object)listener);
        this.zzt.add((com.google.firebase.zza)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeLifecycleEventListener(@NonNull com.google.firebase.zza listener) {
        void var1_1;
        this.zzc();
        Preconditions.checkNotNull((Object)listener);
        this.zzt.remove(var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearInstancesForTest() {
        Object object = zzg;
        synchronized (object) {
            zza.clear();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getPersistenceKey(String name, FirebaseOptions options) {
        void var1_1;
        String string;
        return Base64Utils.encodeUrlSafeNoPadding((byte[])string.getBytes()) + "+" + Base64Utils.encodeUrlSafeNoPadding((byte[])var1_1.getApplicationId().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzd() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = zzg;
        synchronized (object) {
            for (FirebaseApp firebaseApp : zza.values()) {
                arrayList.add(firebaseApp.getName());
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void zze() {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.zzi);
        if (bl) {
            com.google.firebase.FirebaseApp$zzb.zza(this.zzi);
        } else {
            this.zzl.zza(this.isDefaultApp());
        }
        FirebaseApp.zza(FirebaseApp.class, this, zzb, bl);
        if (this.isDefaultApp()) {
            FirebaseApp.zza(FirebaseApp.class, this, zzc, bl);
            FirebaseApp.zza(Context.class, this.zzi, zzd, bl);
        }
    }

    private static <T> void zza(Class<T> clazz, T t, Iterable<String> object, boolean bl) {
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                if (bl && !zze.contains(string)) continue;
                GenericDeclaration genericDeclaration = Class.forName(string);
                int n = ((Method)(genericDeclaration = ((Class)genericDeclaration).getMethod("getInstance", clazz))).getModifiers();
                if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
                ((Method)genericDeclaration).invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzf.contains(string)) {
                    throw new IllegalStateException(string + " is missing, but is required. Check if it has been removed by Proguard.");
                }
                Log.d((String)"FirebaseApp", (String)(string + " is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(string + "#getInstance has been removed by Proguard. Add keep rule to prevent it.");
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.wtf((String)"FirebaseApp", (String)("Failed to initialize " + string), (Throwable)illegalAccessException);
            }
        }
    }

    static final class zza
    implements Executor {
        private static final Handler zza = new Handler(Looper.getMainLooper());

        private zza() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void execute(@NonNull Runnable command) {
            void var1_1;
            zza.post((Runnable)var1_1);
        }

        /* synthetic */ zza(byte by) {
            this();
        }
    }

    @TargetApi(value=24)
    static final class zzb
    extends BroadcastReceiver {
        private static AtomicReference<zzb> zza = new AtomicReference();
        private final Context zzb;

        private zzb(Context context) {
            this.zzb = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = zzg;
            synchronized (object) {
                for (FirebaseApp firebaseApp : zza.values()) {
                    firebaseApp.zze();
                }
            }
            object = this;
            ((zzb)((Object)object)).zzb.unregisterReceiver((BroadcastReceiver)object);
        }

        static /* synthetic */ void zza(Context context) {
            zzb zzb2;
            if (zza.get() == null && zza.compareAndSet(null, zzb2 = new zzb(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzb2, intentFilter);
            }
        }
    }

    @KeepForSdk
    public static interface BackgroundStateChangeListener {
        public void onBackgroundStateChanged(boolean var1);
    }

    @KeepForSdk
    public static interface IdTokenListenersCountChangedListener {
        public void onListenerCountChanged(int var1);
    }

    @KeepForSdk
    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull InternalTokenResult var1);
    }
}

