/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.Strings;
import com.google.firebase.zzb;

public final class FirebaseOptions {
    private final String zzr;
    private final String zzs;
    private final String zzt;
    private final String zzu;
    private final String zzv;
    private final String zzw;
    private final String zzx;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7) {
        Preconditions.checkState((!Strings.isEmptyOrWhitespace((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzs = string;
        this.zzr = string2;
        this.zzt = string3;
        this.zzu = string4;
        this.zzv = string5;
        this.zzw = string6;
        this.zzx = string7;
    }

    public static FirebaseOptions fromResource(Context context) {
        StringResourceValueReader stringResourceValueReader = new StringResourceValueReader(context);
        String string = stringResourceValueReader.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, stringResourceValueReader.getString("google_api_key"), stringResourceValueReader.getString("firebase_database_url"), stringResourceValueReader.getString("ga_trackingId"), stringResourceValueReader.getString("gcm_defaultSenderId"), stringResourceValueReader.getString("google_storage_bucket"), stringResourceValueReader.getString("project_id"));
    }

    public final String getApiKey() {
        return this.zzr;
    }

    public final String getApplicationId() {
        return this.zzs;
    }

    public final String getDatabaseUrl() {
        return this.zzt;
    }

    public final String getGcmSenderId() {
        return this.zzv;
    }

    public final String getStorageBucket() {
        return this.zzw;
    }

    public final String getProjectId() {
        return this.zzx;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return Objects.equal((Object)this.zzs, (Object)firebaseOptions.zzs) && Objects.equal((Object)this.zzr, (Object)firebaseOptions.zzr) && Objects.equal((Object)this.zzt, (Object)firebaseOptions.zzt) && Objects.equal((Object)this.zzu, (Object)firebaseOptions.zzu) && Objects.equal((Object)this.zzv, (Object)firebaseOptions.zzv) && Objects.equal((Object)this.zzw, (Object)firebaseOptions.zzw) && Objects.equal((Object)this.zzx, (Object)firebaseOptions.zzx);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzs, this.zzr, this.zzt, this.zzu, this.zzv, this.zzw, this.zzx});
    }

    public final String toString() {
        return Objects.toStringHelper((Object)this).add("applicationId", (Object)this.zzs).add("apiKey", (Object)this.zzr).add("databaseUrl", (Object)this.zzt).add("gcmSenderId", (Object)this.zzv).add("storageBucket", (Object)this.zzw).add("projectId", (Object)this.zzx).toString();
    }

    /* synthetic */ FirebaseOptions(String string, String string2, String string3, String string4, String string5, String string6, String string7, zzb zzb2) {
        this(string, string2, string3, string4, string5, string6, string7);
    }

    public static final class Builder {
        private String zzr;
        private String zzs;
        private String zzt;
        private String zzu;
        private String zzv;
        private String zzw;
        private String zzx;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzs = firebaseOptions.zzs;
            this.zzr = firebaseOptions.zzr;
            this.zzt = firebaseOptions.zzt;
            this.zzu = firebaseOptions.zzu;
            this.zzv = firebaseOptions.zzv;
            this.zzw = firebaseOptions.zzw;
            this.zzx = firebaseOptions.zzx;
        }

        public final Builder setApiKey(@NonNull String string) {
            this.zzr = Preconditions.checkNotEmpty((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public final Builder setApplicationId(@NonNull String string) {
            this.zzs = Preconditions.checkNotEmpty((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public final Builder setDatabaseUrl(@Nullable String string) {
            this.zzt = string;
            return this;
        }

        public final Builder setGcmSenderId(@Nullable String string) {
            this.zzv = string;
            return this;
        }

        public final Builder setStorageBucket(@Nullable String string) {
            this.zzw = string;
            return this;
        }

        public final Builder setProjectId(@Nullable String string) {
            this.zzx = string;
            return this;
        }

        public final FirebaseOptions build() {
            return new FirebaseOptions(this.zzs, this.zzr, this.zzt, this.zzu, this.zzv, this.zzw, this.zzx, null);
        }
    }
}

