/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.zzc;
import com.google.firebase.components.zzg;
import com.google.firebase.internal.InternalTokenProvider;
import com.google.firebase.internal.InternalTokenResult;
import com.google.firebase.internal.zzb;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zza = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzb = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzc = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzd = Arrays.asList(new String[0]);
    private static final Set<String> zze = Collections.emptySet();
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    static final Map<String, FirebaseApp> zzf = new ArrayMap();
    private final Context zzg;
    private final String mName;
    private final FirebaseOptions zzh;
    private final zzg zzi;
    private final AtomicBoolean zzj = new AtomicBoolean(false);
    private final AtomicBoolean zzk = new AtomicBoolean();
    private final List<IdTokenListener> zzl = new CopyOnWriteArrayList<IdTokenListener>();
    private final List<BackgroundStateChangeListener> zzm = new CopyOnWriteArrayList<BackgroundStateChangeListener>();
    private final List<Object> zzn = new CopyOnWriteArrayList<Object>();
    private InternalTokenProvider zzo;
    private IdTokenListenersCountChangedListener zzp;

    @NonNull
    public Context getApplicationContext() {
        this.zza();
        return this.zzg;
    }

    @NonNull
    public String getName() {
        this.zza();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zza();
        return this.zzh;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.mName).add("options", (Object)this.zzh).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        com.google.firebase.internal.zzb.zze(context);
        Object object = sLock;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzf.values());
            com.google.firebase.internal.zzb.zzq();
            Set<String> set = com.google.firebase.internal.zzb.zzr();
            set.removeAll(zzf.keySet());
            for (String string : set) {
                com.google.firebase.internal.zzb.zzb(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = sLock;
        synchronized (object) {
            FirebaseApp firebaseApp = zzf.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = ProcessUtils.getMyProcessName();
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = sLock;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzf.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzb();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzf.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        com.google.firebase.internal.zzb.zze(context);
        Context context2 = context;
        if (PlatformVersion.isAtLeastIceCreamSandwich() && context2.getApplicationContext() instanceof Application) {
            BackgroundDetector.initialize((Application)((Application)context2.getApplicationContext()));
            BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = sLock;
        synchronized (object) {
            Preconditions.checkState((!zzf.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            Preconditions.checkNotNull((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zzf.put(string2, firebaseApp);
        }
        com.google.firebase.internal.zzb.zzb(firebaseApp);
        firebaseApp.zzc();
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void onBackgroundStateChanged(boolean bl) {
        Object object = sLock;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzf.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzj.get()) continue;
                firebaseApp2.zza(bl);
            }
            return;
        }
    }

    @KeepForSdk
    public void setTokenProvider(@NonNull InternalTokenProvider internalTokenProvider) {
        this.zzo = (InternalTokenProvider)Preconditions.checkNotNull((Object)internalTokenProvider);
    }

    @KeepForSdk
    public void setIdTokenListenersCountChangedListener(@NonNull IdTokenListenersCountChangedListener idTokenListenersCountChangedListener) {
        this.zzp = (IdTokenListenersCountChangedListener)Preconditions.checkNotNull((Object)idTokenListenersCountChangedListener);
        this.zzp.onListenerCountChanged(this.zzl.size());
    }

    @KeepForSdk
    public Task<GetTokenResult> getToken(boolean bl) {
        this.zza();
        if (this.zzo == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzo.getAccessToken(bl);
    }

    @Nullable
    public final String getUid() throws FirebaseApiNotAvailableException {
        this.zza();
        if (this.zzo == null) {
            throw new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode.");
        }
        return this.zzo.getUid();
    }

    @KeepForSdk
    public <T> T get(Class<T> clazz) {
        this.zza();
        return (T)this.zzi.get((Class)clazz);
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zza();
        if (this.zzj.compareAndSet(!bl, bl)) {
            boolean bl2 = BackgroundDetector.getInstance().isInBackground();
            if (bl && bl2) {
                this.zza(true);
                return;
            }
            if (!bl && bl2) {
                this.zza(false);
            }
        }
    }

    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.zzg = (Context)Preconditions.checkNotNull((Object)context);
        this.mName = Preconditions.checkNotEmpty((String)string);
        this.zzh = (FirebaseOptions)Preconditions.checkNotNull((Object)firebaseOptions);
        this.zzp = new com.google.firebase.internal.zza();
        List<ComponentRegistrar> list = new zzc(this.zzg).zzj();
        this.zzi = new zzg(list, Component.of(Context.class, this.zzg), Component.of(FirebaseApp.class, this), Component.of(FirebaseOptions.class, this.zzh));
    }

    private final void zza() {
        Preconditions.checkState((!this.zzk.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    @KeepForSdk
    @VisibleForTesting
    public boolean isDefaultApp() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    @KeepForSdk
    public void notifyIdTokenListeners(@NonNull InternalTokenResult internalTokenResult) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<IdTokenListener> iterator = this.zzl.iterator();
        while (iterator.hasNext()) {
            iterator.next().onIdTokenChanged(internalTokenResult);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zza(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<BackgroundStateChangeListener> iterator = this.zzm.iterator();
        while (iterator.hasNext()) {
            iterator.next().onBackgroundStateChanged(bl);
        }
    }

    @KeepForSdk
    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zza();
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzl.add(idTokenListener);
        this.zzp.onListenerCountChanged(this.zzl.size());
    }

    public final void zza(@NonNull IdTokenListener idTokenListener) {
        this.zza();
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzl.remove(idTokenListener);
        this.zzp.onListenerCountChanged(this.zzl.size());
    }

    @KeepForSdk
    public void addBackgroundStateChangeListener(BackgroundStateChangeListener backgroundStateChangeListener) {
        this.zza();
        if (this.zzj.get() && BackgroundDetector.getInstance().isInBackground()) {
            backgroundStateChangeListener.onBackgroundStateChanged(true);
        }
        this.zzm.add(backgroundStateChangeListener);
    }

    @KeepForSdk
    public void removeBackgroundStateChangeListener(BackgroundStateChangeListener backgroundStateChangeListener) {
        this.zza();
        this.zzm.remove(backgroundStateChangeListener);
    }

    @KeepForSdk
    public String getPersistenceKey() {
        String string = Base64Utils.encodeUrlSafeNoPadding((byte[])this.getName().getBytes());
        String string2 = Base64Utils.encodeUrlSafeNoPadding((byte[])this.getOptions().getApplicationId().getBytes());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzb() {
        ArraySet arraySet = new ArraySet();
        ArrayList<String> arrayList = sLock;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzf.values()) {
                arraySet.add(firebaseApp.getName());
            }
            if (com.google.firebase.internal.zzb.zzq() != null) {
                arraySet.addAll(com.google.firebase.internal.zzb.zzr());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)arraySet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzc() {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.zzg);
        if (bl) {
            com.google.firebase.FirebaseApp$zza.zza(this.zzg);
        } else {
            this.zzi.zzb(this.isDefaultApp());
        }
        FirebaseApp.zza(FirebaseApp.class, this, zza, bl);
        if (this.isDefaultApp()) {
            FirebaseApp.zza(FirebaseApp.class, this, zzb, bl);
            FirebaseApp.zza(Context.class, this.zzg, zzc, bl);
        }
    }

    private static <T> void zza(Class<T> clazz, T t, Iterable<String> iterable, boolean bl) {
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zzd.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zze.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @TargetApi(value=24)
    private static final class zza
    extends BroadcastReceiver {
        private static AtomicReference<zza> zzq = new AtomicReference();
        private final Context zzg;

        private zza(Context context) {
            this.zzg = context;
        }

        private static void zza(Context context) {
            zza zza2;
            if (zzq.get() == null && zzq.compareAndSet(null, zza2 = new zza(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zza2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = sLock;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zzf.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzc();
                }
            }
            zza zza2 = this;
            zza2.zzg.unregisterReceiver((BroadcastReceiver)zza2);
        }
    }

    @KeepForSdk
    public static interface BackgroundStateChangeListener {
        @KeepForSdk
        public void onBackgroundStateChanged(boolean var1);
    }

    @KeepForSdk
    public static interface IdTokenListenersCountChangedListener {
        @KeepForSdk
        public void onListenerCountChanged(int var1);
    }

    @KeepForSdk
    public static interface IdTokenListener {
        @KeepForSdk
        public void onIdTokenChanged(@NonNull InternalTokenResult var1);
    }
}

