/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzca;
import com.google.android.gms.common.util.zzw;
import com.google.firebase.zzc;
import java.util.Arrays;

public final class FirebaseOptions {
    private final String zzmna;
    private final String zzetb;
    private final String zzmnb;
    private final String zzmnc;
    private final String zzmnd;
    private final String zzmne;
    private final String zzmnf;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7) {
        zzbq.zza((!zzw.zzhb((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzetb = string;
        this.zzmna = string2;
        this.zzmnb = string3;
        this.zzmnc = string4;
        this.zzmnd = string5;
        this.zzmne = string6;
        this.zzmnf = string7;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzca zzca2 = new zzca(context);
        String string = zzca2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzca2.getString("google_api_key"), zzca2.getString("firebase_database_url"), zzca2.getString("ga_trackingId"), zzca2.getString("gcm_defaultSenderId"), zzca2.getString("google_storage_bucket"), zzca2.getString("project_id"));
    }

    public final String getApiKey() {
        return this.zzmna;
    }

    public final String getApplicationId() {
        return this.zzetb;
    }

    public final String getDatabaseUrl() {
        return this.zzmnb;
    }

    public final String getGcmSenderId() {
        return this.zzmnd;
    }

    public final String getStorageBucket() {
        return this.zzmne;
    }

    public final String getProjectId() {
        return this.zzmnf;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzbg.equal((Object)this.zzetb, (Object)firebaseOptions.zzetb) && zzbg.equal((Object)this.zzmna, (Object)firebaseOptions.zzmna) && zzbg.equal((Object)this.zzmnb, (Object)firebaseOptions.zzmnb) && zzbg.equal((Object)this.zzmnc, (Object)firebaseOptions.zzmnc) && zzbg.equal((Object)this.zzmnd, (Object)firebaseOptions.zzmnd) && zzbg.equal((Object)this.zzmne, (Object)firebaseOptions.zzmne) && zzbg.equal((Object)this.zzmnf, (Object)firebaseOptions.zzmnf);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzetb, this.zzmna, this.zzmnb, this.zzmnc, this.zzmnd, this.zzmne, this.zzmnf});
    }

    public final String toString() {
        return zzbg.zzx((Object)this).zzg("applicationId", (Object)this.zzetb).zzg("apiKey", (Object)this.zzmna).zzg("databaseUrl", (Object)this.zzmnb).zzg("gcmSenderId", (Object)this.zzmnd).zzg("storageBucket", (Object)this.zzmne).zzg("projectId", (Object)this.zzmnf).toString();
    }

    /* synthetic */ FirebaseOptions(String string, String string2, String string3, String string4, String string5, String string6, String string7, zzc zzc2) {
        this(string, string2, string3, string4, string5, string6, string7);
    }

    public static final class Builder {
        private String zzmna;
        private String zzetb;
        private String zzmnb;
        private String zzmnc;
        private String zzmnd;
        private String zzmne;
        private String zzmnf;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzetb = firebaseOptions.zzetb;
            this.zzmna = firebaseOptions.zzmna;
            this.zzmnb = firebaseOptions.zzmnb;
            this.zzmnc = firebaseOptions.zzmnc;
            this.zzmnd = firebaseOptions.zzmnd;
            this.zzmne = firebaseOptions.zzmne;
            this.zzmnf = firebaseOptions.zzmnf;
        }

        public final Builder setApiKey(@NonNull String string) {
            this.zzmna = zzbq.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public final Builder setApplicationId(@NonNull String string) {
            this.zzetb = zzbq.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public final Builder setDatabaseUrl(@Nullable String string) {
            this.zzmnb = string;
            return this;
        }

        public final Builder setGcmSenderId(@Nullable String string) {
            this.zzmnd = string;
            return this;
        }

        public final Builder setStorageBucket(@Nullable String string) {
            this.zzmne = string;
            return this;
        }

        public final Builder setProjectId(@Nullable String string) {
            this.zzmnf = string;
            return this;
        }

        public final FirebaseOptions build() {
            return new FirebaseOptions(this.zzetb, this.zzmna, this.zzmnb, this.zzmnc, this.zzmnd, this.zzmne, this.zzmnf, null);
        }
    }
}

