/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzu;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.internal.InternalTokenProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzmmm = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzmmn = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzmmo = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzmmp = Arrays.asList(new String[0]);
    private static final Set<String> zzmmq = Collections.emptySet();
    private static final Object sLock = new Object();
    static final Map<String, FirebaseApp> zzimu = new ArrayMap();
    private final Context mApplicationContext;
    private final String mName;
    private final FirebaseOptions zzmmr;
    private final AtomicBoolean zzmms = new AtomicBoolean(false);
    private final AtomicBoolean zzmmt = new AtomicBoolean();
    private final List<IdTokenListener> zzmmu = new CopyOnWriteArrayList<IdTokenListener>();
    private final List<zza> zzmmv = new CopyOnWriteArrayList<zza>();
    private final List<Object> zzmmw = new CopyOnWriteArrayList<Object>();
    private InternalTokenProvider zzmmx;
    private zzb zzmmy;

    @NonNull
    public Context getApplicationContext() {
        this.zzbst();
        return this.mApplicationContext;
    }

    @NonNull
    public String getName() {
        this.zzbst();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzbst();
        return this.zzmmr;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzbg.zzx((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzmmr).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        com.google.firebase.internal.zzb.zzfb(context);
        Object object = sLock;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzimu.values());
            com.google.firebase.internal.zzb.zzclx();
            Set<String> set = com.google.firebase.internal.zzb.zzcly();
            set.removeAll(zzimu.keySet());
            for (String string : set) {
                com.google.firebase.internal.zzb.zzrw(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = sLock;
        synchronized (object) {
            FirebaseApp firebaseApp = zzimu.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = zzu.zzany();
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = sLock;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzimu.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzbsw();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzimu.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        com.google.firebase.internal.zzb.zzfb(context);
        Context context2 = context;
        if (context2.getApplicationContext() instanceof Application) {
            zzk.zza((Application)((Application)context2.getApplicationContext()));
            zzk.zzaij().zza((zzl)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = sLock;
        synchronized (object) {
            zzbq.zza((!zzimu.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzbq.checkNotNull((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zzimu.put(string2, firebaseApp);
        }
        com.google.firebase.internal.zzb.zzg(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzmmm);
        if (firebaseApp.zzbsu()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzmmn);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzmmo);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public static void zzbj(boolean bl) {
        Object object = sLock;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzimu.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzmms.get()) continue;
                firebaseApp2.zzci(bl);
            }
            return;
        }
    }

    @Hide
    public final void zza(@NonNull InternalTokenProvider internalTokenProvider) {
        this.zzmmx = (InternalTokenProvider)zzbq.checkNotNull((Object)internalTokenProvider);
    }

    @Hide
    public final void zza(@NonNull zzb zzb2) {
        this.zzmmy = (zzb)zzbq.checkNotNull((Object)zzb2);
        this.zzmmy.zzha(this.zzmmu.size());
    }

    @Hide
    @KeepForSdk
    public Task<GetTokenResult> getToken(boolean bl) {
        this.zzbst();
        if (this.zzmmx == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzmmx.zzcj(bl);
    }

    @Hide
    @Nullable
    public final String getUid() throws FirebaseApiNotAvailableException {
        this.zzbst();
        if (this.zzmmx == null) {
            throw new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode.");
        }
        return this.zzmmx.getUid();
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzbst();
        if (this.zzmms.compareAndSet(!bl, bl)) {
            boolean bl2 = zzk.zzaij().zzaik();
            if (bl && bl2) {
                this.zzci(true);
                return;
            }
            if (!bl && bl2) {
                this.zzci(false);
            }
        }
    }

    @Hide
    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.mApplicationContext = (Context)zzbq.checkNotNull((Object)context);
        this.mName = zzbq.zzgv((String)string);
        this.zzmmr = (FirebaseOptions)zzbq.checkNotNull((Object)firebaseOptions);
        this.zzmmy = new com.google.firebase.internal.zza();
    }

    private final void zzbst() {
        zzbq.zza((!this.zzmmt.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    @Hide
    public final boolean zzbsu() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @Hide
    @UiThread
    public final void zza(@NonNull com.google.firebase.internal.zzc zzc2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<IdTokenListener> iterator = this.zzmmu.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb(zzc2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zzci(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<zza> iterator = this.zzmmv.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzbj(bl);
        }
    }

    @Hide
    public final void zza(@NonNull IdTokenListener idTokenListener) {
        this.zzbst();
        zzbq.checkNotNull((Object)idTokenListener);
        this.zzmmu.add(idTokenListener);
        this.zzmmy.zzha(this.zzmmu.size());
    }

    @Hide
    public final void zzb(@NonNull IdTokenListener idTokenListener) {
        this.zzbst();
        zzbq.checkNotNull((Object)idTokenListener);
        this.zzmmu.remove(idTokenListener);
        this.zzmmy.zzha(this.zzmmu.size());
    }

    @Hide
    public final void zza(zza zza2) {
        this.zzbst();
        if (this.zzmms.get() && zzk.zzaij().zzaik()) {
            zza2.zzbj(true);
        }
        this.zzmmv.add(zza2);
    }

    @Hide
    public final String zzbsv() {
        String string = com.google.android.gms.common.util.zzc.zzl((byte[])this.getName().getBytes());
        String string2 = com.google.android.gms.common.util.zzc.zzl((byte[])this.getOptions().getApplicationId().getBytes());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzbsw() {
        ArraySet arraySet = new ArraySet();
        ArrayList<String> arrayList = sLock;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzimu.values()) {
                arraySet.add(firebaseApp.getName());
            }
            if (com.google.firebase.internal.zzb.zzclx() != null) {
                arraySet.addAll(com.google.firebase.internal.zzb.zzcly());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)arraySet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzbsx() {
        this.zza(FirebaseApp.class, this, zzmmm);
        if (this.zzbsu()) {
            this.zza(FirebaseApp.class, this, zzmmn);
            this.zza(Context.class, this.mApplicationContext, zzmmo);
        }
    }

    private final <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.mApplicationContext);
        if (bl) {
            zzc.zzew(this.mApplicationContext);
        }
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zzmmp.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzmmq.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @Hide
    @TargetApi(value=24)
    static final class zzc
    extends BroadcastReceiver {
        private static AtomicReference<zzc> zzmmz = new AtomicReference();
        private final Context mApplicationContext;

        private zzc(Context context) {
            this.mApplicationContext = context;
        }

        private static void zzew(Context context) {
            zzc zzc2;
            if (zzmmz.get() == null && zzmmz.compareAndSet(null, zzc2 = new zzc(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzc2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = sLock;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zzimu.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzbsx();
                }
            }
            zzc zzc2 = this;
            zzc2.mApplicationContext.unregisterReceiver((BroadcastReceiver)zzc2);
        }
    }

    @Hide
    public static interface zza {
        public void zzbj(boolean var1);
    }

    @Hide
    public static interface zzb {
        public void zzha(int var1);
    }

    @Hide
    @KeepForSdk
    public static interface IdTokenListener {
        public void zzb(@NonNull com.google.firebase.internal.zzc var1);
    }
}

