/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.internal.InternalTokenProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzman = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzmao = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzmap = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzmaq = Arrays.asList(new String[0]);
    private static final Set<String> zzmar = Collections.emptySet();
    private static final Object sLock = new Object();
    static final Map<String, FirebaseApp> zzifg = new ArrayMap();
    private final Context mApplicationContext;
    private final String mName;
    private final FirebaseOptions zzmas;
    private final AtomicBoolean zzmat = new AtomicBoolean(false);
    private final AtomicBoolean zzmau = new AtomicBoolean();
    private final List<IdTokenListener> zzmav = new CopyOnWriteArrayList<IdTokenListener>();
    private final List<zza> zzmaw = new CopyOnWriteArrayList<zza>();
    private final List<Object> zzmax = new CopyOnWriteArrayList<Object>();
    private InternalTokenProvider zzmay;
    private zzb zzmaz;

    @NonNull
    public Context getApplicationContext() {
        this.zzbqn();
        return this.mApplicationContext;
    }

    @NonNull
    public String getName() {
        this.zzbqn();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzbqn();
        return this.zzmas;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzbg.zzx((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzmas).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        com.google.firebase.internal.zzb.zzew(context);
        Object object = sLock;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzifg.values());
            com.google.firebase.internal.zzb.zzcjr();
            Set<String> set = com.google.firebase.internal.zzb.zzcjs();
            set.removeAll(zzifg.keySet());
            for (String string : set) {
                com.google.firebase.internal.zzb.zzrq(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = sLock;
        synchronized (object) {
            FirebaseApp firebaseApp = zzifg.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = zzs.zzamo();
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = sLock;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzifg.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzbqq();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzifg.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        com.google.firebase.internal.zzb.zzew(context);
        Context context2 = context;
        if (context2.getApplicationContext() instanceof Application) {
            zzk.zza((Application)((Application)context2.getApplicationContext()));
            zzk.zzahb().zza((zzl)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = sLock;
        synchronized (object) {
            zzbq.zza((!zzifg.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzbq.checkNotNull((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zzifg.put(string2, firebaseApp);
        }
        com.google.firebase.internal.zzb.zzg(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzman);
        if (firebaseApp.zzbqo()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzmao);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzmap);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzbf(boolean bl) {
        Object object = sLock;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzifg.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzmat.get()) continue;
                firebaseApp2.zzcd(bl);
            }
            return;
        }
    }

    public final void zza(@NonNull InternalTokenProvider internalTokenProvider) {
        this.zzmay = (InternalTokenProvider)zzbq.checkNotNull((Object)internalTokenProvider);
    }

    public final void zza(@NonNull zzb zzb2) {
        this.zzmaz = (zzb)zzbq.checkNotNull((Object)zzb2);
        this.zzmaz.zzgj(this.zzmav.size());
    }

    @KeepForSdk
    public Task<GetTokenResult> getToken(boolean bl) {
        this.zzbqn();
        if (this.zzmay == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzmay.zzce(bl);
    }

    @Nullable
    public final String getUid() throws FirebaseApiNotAvailableException {
        this.zzbqn();
        if (this.zzmay == null) {
            throw new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode.");
        }
        return this.zzmay.getUid();
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzbqn();
        if (this.zzmat.compareAndSet(!bl, bl)) {
            boolean bl2 = zzk.zzahb().zzahc();
            if (bl && bl2) {
                this.zzcd(true);
                return;
            }
            if (!bl && bl2) {
                this.zzcd(false);
            }
        }
    }

    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.mApplicationContext = (Context)zzbq.checkNotNull((Object)context);
        this.mName = zzbq.zzgm((String)string);
        this.zzmas = (FirebaseOptions)zzbq.checkNotNull((Object)firebaseOptions);
        this.zzmaz = new com.google.firebase.internal.zza();
    }

    private final void zzbqn() {
        zzbq.zza((!this.zzmau.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public final boolean zzbqo() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public final void zza(@NonNull com.google.firebase.internal.zzc zzc2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<IdTokenListener> iterator = this.zzmav.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb(zzc2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zzcd(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<zza> iterator = this.zzmaw.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzbf(bl);
        }
    }

    public final void zza(@NonNull IdTokenListener idTokenListener) {
        this.zzbqn();
        zzbq.checkNotNull((Object)idTokenListener);
        this.zzmav.add(idTokenListener);
        this.zzmaz.zzgj(this.zzmav.size());
    }

    public final void zzb(@NonNull IdTokenListener idTokenListener) {
        this.zzbqn();
        zzbq.checkNotNull((Object)idTokenListener);
        this.zzmav.remove(idTokenListener);
        this.zzmaz.zzgj(this.zzmav.size());
    }

    public final void zza(zza zza2) {
        this.zzbqn();
        if (this.zzmat.get() && zzk.zzahb().zzahc()) {
            zza2.zzbf(true);
        }
        this.zzmaw.add(zza2);
    }

    public final String zzbqp() {
        String string = com.google.android.gms.common.util.zzb.zzm((byte[])this.getName().getBytes());
        String string2 = com.google.android.gms.common.util.zzb.zzm((byte[])this.getOptions().getApplicationId().getBytes());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzbqq() {
        ArraySet arraySet = new ArraySet();
        ArrayList<String> arrayList = sLock;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzifg.values()) {
                arraySet.add(firebaseApp.getName());
            }
            if (com.google.firebase.internal.zzb.zzcjr() != null) {
                arraySet.addAll(com.google.firebase.internal.zzb.zzcjs());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)arraySet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzbqr() {
        this.zza(FirebaseApp.class, this, zzman);
        if (this.zzbqo()) {
            this.zza(FirebaseApp.class, this, zzmao);
            this.zza(Context.class, this.mApplicationContext, zzmap);
        }
    }

    private final <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.mApplicationContext);
        if (bl) {
            zzc.zzer(this.mApplicationContext);
        }
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zzmaq.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzmar.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @TargetApi(value=24)
    static final class zzc
    extends BroadcastReceiver {
        private static AtomicReference<zzc> zzmba = new AtomicReference();
        private final Context mApplicationContext;

        private zzc(Context context) {
            this.mApplicationContext = context;
        }

        private static void zzer(Context context) {
            zzc zzc2;
            if (zzmba.get() == null && zzmba.compareAndSet(null, zzc2 = new zzc(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzc2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = sLock;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zzifg.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzbqr();
                }
            }
            zzc zzc2 = this;
            zzc2.mApplicationContext.unregisterReceiver((BroadcastReceiver)zzc2);
        }
    }

    public static interface zza {
        public void zzbf(boolean var1);
    }

    public static interface zzb {
        public void zzgj(int var1);
    }

    @KeepForSdk
    public static interface IdTokenListener {
        public void zzb(@NonNull com.google.firebase.internal.zzc var1);
    }
}

