/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzeam;
import com.google.android.gms.internal.zzean;
import com.google.android.gms.internal.zzeao;
import com.google.android.gms.internal.zzeap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzlfz = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzlga = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzlgb = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzlgc = Arrays.asList(new String[0]);
    private static final Set<String> zzlgd = Collections.emptySet();
    private static final Object zzaqc = new Object();
    static final Map<String, FirebaseApp> zzhtm = new ArrayMap();
    private final Context mApplicationContext;
    private final String mName;
    private final FirebaseOptions zzlge;
    private final AtomicBoolean zzlgf = new AtomicBoolean(false);
    private final AtomicBoolean zzlgg = new AtomicBoolean();
    private final List<zzb> zzlgh = new CopyOnWriteArrayList<zzb>();
    private final List<zza> zzlgi = new CopyOnWriteArrayList<zza>();
    private final List<Object> zzlgj = new CopyOnWriteArrayList<Object>();
    private zzeao zzlgk;
    private zzc zzlgl;

    @NonNull
    public Context getApplicationContext() {
        this.zzbnm();
        return this.mApplicationContext;
    }

    @NonNull
    public String getName() {
        this.zzbnm();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzbnm();
        return this.zzlge;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzbf.zzt((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzlge).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        zzean.zzep(context);
        Object object = zzaqc;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzhtm.values());
            zzean.zzbyu();
            Set<String> set = zzean.zzbyv();
            set.removeAll(zzhtm.keySet());
            for (String string : set) {
                zzean.zzql(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zzaqc;
        synchronized (object) {
            FirebaseApp firebaseApp = zzhtm.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = zzq.zzall();
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzaqc;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzhtm.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzbnp();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zzaqc;
        synchronized (object) {
            if (zzhtm.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzean.zzep(context);
        Context context2 = context;
        if (context2.getApplicationContext() instanceof Application) {
            zzk.zza((Application)((Application)context2.getApplicationContext()));
            zzk.zzafz().zza((zzl)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = zzaqc;
        synchronized (object) {
            zzbp.zza((!zzhtm.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzbp.zzb((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zzhtm.put(string2, firebaseApp);
        }
        zzean.zze(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzlfz);
        if (firebaseApp.zzbnn()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzlga);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzlgb);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzbe(boolean bl) {
        Object object = zzaqc;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzhtm.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzlgf.get()) continue;
                firebaseApp2.zzbz(bl);
            }
            return;
        }
    }

    public final void zza(@NonNull zzeao zzeao2) {
        this.zzlgk = (zzeao)zzbp.zzu((Object)zzeao2);
    }

    public final Task<GetTokenResult> getToken(boolean bl) {
        this.zzbnm();
        if (this.zzlgk == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzlgk.zzca(bl);
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzbnm();
        if (this.zzlgf.compareAndSet(!bl, bl)) {
            boolean bl2 = zzk.zzafz().zzaga();
            if (bl && bl2) {
                this.zzbz(true);
                return;
            }
            if (!bl && bl2) {
                this.zzbz(false);
            }
        }
    }

    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.mApplicationContext = (Context)zzbp.zzu((Object)context);
        this.mName = zzbp.zzgg((String)string);
        this.zzlge = (FirebaseOptions)zzbp.zzu((Object)firebaseOptions);
        this.zzlgl = new zzeam();
    }

    private final void zzbnm() {
        zzbp.zza((!this.zzlgg.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public final boolean zzbnn() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public final void zza(@NonNull zzeap zzeap2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<zzb> iterator = this.zzlgh.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb(zzeap2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zzbz(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<zza> iterator = this.zzlgi.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzbe(bl);
        }
    }

    public final void zza(@NonNull zzb zzb2) {
        this.zzbnm();
        zzbp.zzu((Object)zzb2);
        this.zzlgh.add(zzb2);
        this.zzlgh.size();
    }

    public final void zza(zza zza2) {
        this.zzbnm();
        if (this.zzlgf.get() && zzk.zzafz().zzaga()) {
            zza2.zzbe(true);
        }
        this.zzlgi.add(zza2);
    }

    public final String zzbno() {
        String string = com.google.android.gms.common.util.zzb.zzk((byte[])this.getName().getBytes());
        String string2 = com.google.android.gms.common.util.zzb.zzk((byte[])this.getOptions().getApplicationId().getBytes());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzbnp() {
        ArraySet arraySet = new ArraySet();
        ArrayList<String> arrayList = zzaqc;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzhtm.values()) {
                arraySet.add(firebaseApp.getName());
            }
            if (zzean.zzbyu() != null) {
                arraySet.addAll(zzean.zzbyv());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)arraySet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzbnq() {
        this.zza(FirebaseApp.class, this, zzlfz);
        if (this.zzbnn()) {
            this.zza(FirebaseApp.class, this, zzlga);
            this.zza(Context.class, this.mApplicationContext, zzlgb);
        }
    }

    private final <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.mApplicationContext);
        if (bl) {
            zzd.zzef(this.mApplicationContext);
        }
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zzlgc.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzlgd.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @TargetApi(value=24)
    static final class zzd
    extends BroadcastReceiver {
        private static AtomicReference<zzd> zzlgm = new AtomicReference();
        private final Context mApplicationContext;

        private zzd(Context context) {
            this.mApplicationContext = context;
        }

        private static void zzef(Context context) {
            zzd zzd2;
            if (zzlgm.get() == null && zzlgm.compareAndSet(null, zzd2 = new zzd(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzd2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = zzaqc;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zzhtm.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzbnq();
                }
            }
            zzd zzd2 = this;
            zzd2.mApplicationContext.unregisterReceiver((BroadcastReceiver)zzd2);
        }
    }

    public static interface zza {
        public void zzbe(boolean var1);
    }

    public static interface zzc {
    }

    public static interface zzb {
        public void zzb(@NonNull zzeap var1);
    }
}

