/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzcb;
import com.google.android.gms.common.util.zzv;
import com.google.firebase.zzc;
import java.util.Arrays;

public final class FirebaseOptions {
    private final String zzbXh;
    private final String zzaoO;
    private final String zzbXi;
    private final String zzbXj;
    private final String zzbXk;
    private final String zzbXl;
    private final String zzbXm;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7) {
        zzbr.zza((!zzv.zzcM((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzaoO = string;
        this.zzbXh = string2;
        this.zzbXi = string3;
        this.zzbXj = string4;
        this.zzbXk = string5;
        this.zzbXl = string6;
        this.zzbXm = string7;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzcb zzcb2 = new zzcb(context);
        String string = zzcb2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzcb2.getString("google_api_key"), zzcb2.getString("firebase_database_url"), zzcb2.getString("ga_trackingId"), zzcb2.getString("gcm_defaultSenderId"), zzcb2.getString("google_storage_bucket"), zzcb2.getString("project_id"));
    }

    public final String getApiKey() {
        return this.zzbXh;
    }

    public final String getApplicationId() {
        return this.zzaoO;
    }

    public final String getDatabaseUrl() {
        return this.zzbXi;
    }

    public final String getGcmSenderId() {
        return this.zzbXk;
    }

    public final String getStorageBucket() {
        return this.zzbXl;
    }

    public final String getProjectId() {
        return this.zzbXm;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzbh.equal((Object)this.zzaoO, (Object)firebaseOptions.zzaoO) && zzbh.equal((Object)this.zzbXh, (Object)firebaseOptions.zzbXh) && zzbh.equal((Object)this.zzbXi, (Object)firebaseOptions.zzbXi) && zzbh.equal((Object)this.zzbXj, (Object)firebaseOptions.zzbXj) && zzbh.equal((Object)this.zzbXk, (Object)firebaseOptions.zzbXk) && zzbh.equal((Object)this.zzbXl, (Object)firebaseOptions.zzbXl) && zzbh.equal((Object)this.zzbXm, (Object)firebaseOptions.zzbXm);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaoO, this.zzbXh, this.zzbXi, this.zzbXj, this.zzbXk, this.zzbXl, this.zzbXm});
    }

    public final String toString() {
        return zzbh.zzt((Object)this).zzg("applicationId", (Object)this.zzaoO).zzg("apiKey", (Object)this.zzbXh).zzg("databaseUrl", (Object)this.zzbXi).zzg("gcmSenderId", (Object)this.zzbXk).zzg("storageBucket", (Object)this.zzbXl).zzg("projectId", (Object)this.zzbXm).toString();
    }

    /* synthetic */ FirebaseOptions(String string, String string2, String string3, String string4, String string5, String string6, String string7, zzc zzc2) {
        this(string, string2, string3, string4, string5, string6, string7);
    }

    public static final class Builder {
        private String zzbXh;
        private String zzaoO;
        private String zzbXi;
        private String zzbXj;
        private String zzbXk;
        private String zzbXl;
        private String zzbXm;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzaoO = firebaseOptions.zzaoO;
            this.zzbXh = firebaseOptions.zzbXh;
            this.zzbXi = firebaseOptions.zzbXi;
            this.zzbXj = firebaseOptions.zzbXj;
            this.zzbXk = firebaseOptions.zzbXk;
            this.zzbXl = firebaseOptions.zzbXl;
            this.zzbXm = firebaseOptions.zzbXm;
        }

        public final Builder setApiKey(@NonNull String string) {
            this.zzbXh = zzbr.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public final Builder setApplicationId(@NonNull String string) {
            this.zzaoO = zzbr.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public final Builder setDatabaseUrl(@Nullable String string) {
            this.zzbXi = string;
            return this;
        }

        public final Builder setGcmSenderId(@Nullable String string) {
            this.zzbXk = string;
            return this;
        }

        public final Builder setStorageBucket(@Nullable String string) {
            this.zzbXl = string;
            return this;
        }

        public final Builder setProjectId(@Nullable String string) {
            this.zzbXm = string;
            return this;
        }

        public final FirebaseOptions build() {
            return new FirebaseOptions(this.zzaoO, this.zzbXh, this.zzbXi, this.zzbXj, this.zzbXk, this.zzbXl, this.zzbXm, null);
        }
    }
}

