/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.internal.firebase-auth-api.zzagl;
import com.google.android.gms.internal.firebase-auth-api.zzzh;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.TotpMultiFactorInfo;
import com.google.firebase.auth.internal.zzad;
import com.google.firebase.auth.internal.zzaf;
import com.google.firebase.auth.internal.zzah;
import com.google.firebase.auth.internal.zzz;
import com.google.firebase.auth.zzan;
import java.util.ArrayList;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzca {
    private Context zza;
    private String zzb;
    private SharedPreferences zzc;
    private Logger zzd;

    @Nullable
    public final FirebaseUser zza() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzc.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zza(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    @Nullable
    public final zzagl zza(FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        String string = this.zzc.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzagl.zzb(string);
        }
        return null;
    }

    @Nullable
    private final zzad zza(JSONObject jSONObject) {
        try {
            String string;
            int n;
            ArrayList<MultiFactorInfo> arrayList;
            zzagl zzagl2;
            JSONArray jSONArray;
            int n2;
            String string2 = jSONObject.getString("cachedTokenState");
            String string3 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string4 = "2";
            String string5 = jSONObject.getString("version");
            if (string5 != null) {
                string4 = string5;
            }
            if ((n2 = (jSONArray = jSONObject.getJSONArray("userInfos")).length()) == 0) {
                return null;
            }
            ArrayList<zzz> arrayList2 = new ArrayList<zzz>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList2.add(zzz.zza(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string3);
            zzad zzad2 = new zzad(firebaseApp, arrayList2);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                zzagl2 = zzagl.zzb(string2);
                ((FirebaseUser)zzad2).zza(zzagl2);
            }
            if (!bl) {
                ((FirebaseUser)zzad2).zzb();
            }
            zzad2.zza(string4);
            if (jSONObject.has("userMetadata") && (arrayList = zzaf.zza(jSONObject.getJSONObject("userMetadata"))) != null) {
                zzad2.zza((zzaf)((Object)arrayList));
            }
            if (jSONObject.has("userMultiFactorInfo") && (zzagl2 = jSONObject.getJSONArray("userMultiFactorInfo")) != null) {
                arrayList = new ArrayList();
                for (n = 0; n < zzagl2.length(); ++n) {
                    string = zzagl2.getString(n);
                    JSONObject jSONObject2 = new JSONObject(string);
                    String string6 = jSONObject2.optString("factorIdKey");
                    arrayList.add("phone".equals(string6) ? PhoneMultiFactorInfo.zza(jSONObject2) : (Objects.equals(string6, "totp") ? TotpMultiFactorInfo.zza(jSONObject2) : null));
                }
                ((FirebaseUser)zzad2).zzc(arrayList);
            }
            if (jSONObject.has("passkeyInfo") && (zzagl2 = jSONObject.getJSONArray("passkeyInfo")) != null) {
                arrayList = new ArrayList<MultiFactorInfo>();
                for (n = 0; n < zzagl2.length(); ++n) {
                    string = zzagl2.getString(n);
                    arrayList.add((MultiFactorInfo)((Object)zzan.zza(new JSONObject(string))));
                }
                ((FirebaseUser)zzad2).zzb(arrayList);
            }
            return zzad2;
        }
        catch (zzzh | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzd.wtf(throwable);
            return null;
        }
    }

    @Nullable
    private final String zzc(FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzad.class.isAssignableFrom(firebaseUser.getClass())) {
            zzad zzad2 = (zzad)firebaseUser;
            try {
                int n;
                int n2;
                JSONArray jSONArray;
                Object object;
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzad2).zze());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzad2).zza().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzad2.zzj() != null) {
                    Object object2;
                    int n3;
                    object = new JSONArray();
                    jSONArray = zzad2.zzj();
                    n2 = jSONArray.size();
                    if (jSONArray.size() > 30) {
                        n2 = 30;
                        this.zzd.w("Provider user info list size larger than max size, truncating list to %d. Actual list size: %d", new Object[]{30, jSONArray.size()});
                    }
                    n = 0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        object2 = jSONArray.get(n3);
                        if (((zzz)object2).getProviderId().equals("firebase")) {
                            n = 1;
                        }
                        if (n3 == n2 - 1 && n == 0) break;
                        object.put((Object)((zzz)object2).zzb());
                    }
                    if (n == 0) {
                        for (n3 = n2 - 1; n3 < jSONArray.size() && n3 >= 0; ++n3) {
                            object2 = (zzz)jSONArray.get(n3);
                            if (((zzz)object2).getProviderId().equals("firebase")) {
                                n = 1;
                                object.put((Object)((zzz)object2).zzb());
                                break;
                            }
                            if (n3 != jSONArray.size() - 1) continue;
                            object.put((Object)((zzz)object2).zzb());
                        }
                        if (n == 0) {
                            this.zzd.w("Malformed user object! No Firebase Auth provider id found. Provider user info list size: %d, trimmed size: %d", new Object[]{jSONArray.size(), n2});
                            if (jSONArray.size() < 5) {
                                StringBuilder stringBuilder = new StringBuilder("Provider user info list:\n");
                                for (zzz zzz2 : jSONArray) {
                                    stringBuilder.append(String.format("Provider - %s\n", zzz2.getProviderId()));
                                }
                                this.zzd.w(stringBuilder.toString(), new Object[0]);
                            }
                        }
                    }
                    jSONObject.put("userInfos", object);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzad2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                if (((FirebaseUser)zzad2).getMetadata() != null) {
                    jSONObject.put("userMetadata", (Object)((zzaf)((FirebaseUser)zzad2).getMetadata()).zza());
                }
                if ((object = ((MultiFactor)((zzah)((FirebaseUser)zzad2).getMultiFactor())).getEnrolledFactors()) != null && !object.isEmpty()) {
                    jSONArray = new JSONArray();
                    for (n2 = 0; n2 < object.size(); ++n2) {
                        jSONArray.put((Object)((MultiFactorInfo)((Object)object.get(n2))).toJson());
                    }
                    jSONObject.put("userMultiFactorInfo", (Object)jSONArray);
                }
                if ((jSONArray = ((FirebaseUser)zzad2).zzf()) != null && !jSONArray.isEmpty()) {
                    JSONArray jSONArray2 = new JSONArray();
                    for (n = 0; n < jSONArray.size(); ++n) {
                        jSONArray2.put((Object)zzan.zza((zzan)((Object)jSONArray.get(n))));
                    }
                    jSONObject.put("passkeyInfo", (Object)jSONArray2);
                }
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzd.wtf("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzzh(exception);
            }
        }
        return null;
    }

    public zzca(Context context, String string) {
        Preconditions.checkNotNull((Object)context);
        this.zzb = Preconditions.checkNotEmpty((String)string);
        this.zza = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzb);
        this.zzc = this.zza.getSharedPreferences(string2, 0);
        this.zzd = new Logger("StorageHelpers", new String[0]);
    }

    public final void zza(String string) {
        this.zzc.edit().remove(string).apply();
    }

    public final void zzb(FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        String string = this.zzc(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzc.edit().putString(string3, string2).apply();
        }
    }

    public final void zza(FirebaseUser firebaseUser, zzagl zzagl2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzagl2);
        this.zzc.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzagl2.zzf()).apply();
    }
}

