/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzads;
import com.google.android.gms.internal.firebase-auth-api.zzafb;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.GenericIdpActivity;
import com.google.firebase.auth.zzal;
import com.google.firebase.auth.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OAuthProvider
extends FederatedAuthProvider {
    private final Bundle zza;

    @Deprecated
    @NonNull
    public static AuthCredential getCredential(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return zze.zza(string, string2, string3);
    }

    @NonNull
    public static Builder newBuilder(@NonNull String string) {
        return OAuthProvider.newBuilder(string, FirebaseAuth.getInstance());
    }

    @NonNull
    public static Builder newBuilder(@NonNull String string, @NonNull FirebaseAuth firebaseAuth) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseAuth);
        if ("facebook.com".equals(string) && !zzafb.zza(firebaseAuth.getApp())) {
            throw new IllegalArgumentException("Sign in with Facebook is not supported via this method; the Facebook TOS dictate that you must use the Facebook Android SDK for Facebook login.");
        }
        return new Builder(string, firebaseAuth, null);
    }

    @NonNull
    public static CredentialBuilder newCredentialBuilder(@NonNull String string) {
        return new CredentialBuilder(Preconditions.checkNotEmpty((String)string), null);
    }

    @Nullable
    public String getProviderId() {
        if (this.zza == null) {
            return null;
        }
        return this.zza.getString("com.google.firebase.auth.KEY_PROVIDER_ID");
    }

    private OAuthProvider(Bundle bundle) {
        this.zza = bundle;
    }

    /* synthetic */ OAuthProvider(Bundle bundle, zzal zzal2) {
        this(bundle);
    }

    @Override
    public final void zza(@NonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_LINK");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzb(@NonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzc(@NonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    public static class Builder {
        private final FirebaseAuth zza;
        @VisibleForTesting
        private final Bundle zzb = new Bundle();
        private final Bundle zzc = new Bundle();

        @NonNull
        public Builder addCustomParameter(@NonNull String string, @NonNull String string2) {
            this.zzc.putString(string, string2);
            return this;
        }

        @NonNull
        public Builder addCustomParameters(@NonNull Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.zzc.putString(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @NonNull
        public Builder setScopes(@NonNull List<String> list) {
            this.zzb.putStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES", new ArrayList<String>(list));
            return this;
        }

        @NonNull
        public OAuthProvider build() {
            return new OAuthProvider(this.zzb, null);
        }

        @KeepForSdk
        @NonNull
        public List<String> getScopes() {
            ArrayList arrayList = this.zzb.getStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
            if (arrayList != null) {
                return arrayList;
            }
            return Collections.emptyList();
        }

        private Builder(String string, FirebaseAuth firebaseAuth) {
            this.zza = firebaseAuth;
            this.zzb.putString("com.google.firebase.auth.KEY_API_KEY", this.zza.getApp().getOptions().getApiKey());
            this.zzb.putString("com.google.firebase.auth.KEY_PROVIDER_ID", string);
            this.zzb.putBundle("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS", this.zzc);
            this.zzb.putString("com.google.firebase.auth.internal.CLIENT_VERSION", zzads.zza().zzb());
            this.zzb.putString("com.google.firebase.auth.KEY_TENANT_ID", this.zza.getTenantId());
            this.zzb.putString("com.google.firebase.auth.KEY_FIREBASE_APP_NAME", this.zza.getApp().getName());
            this.zzb.putString("com.google.firebase.auth.KEY_CUSTOM_AUTH_DOMAIN", this.zza.getCustomAuthDomain());
        }

        /* synthetic */ Builder(String string, FirebaseAuth firebaseAuth, zzal zzal2) {
            this(string, firebaseAuth);
        }
    }

    public static class CredentialBuilder {
        private final String zza;
        @Nullable
        private String zzb;
        @Nullable
        private String zzc;
        @Nullable
        private String zzd;

        @NonNull
        public AuthCredential build() {
            return zze.zza(this.zza, this.zzb, this.zzc, this.zzd);
        }

        @NonNull
        public CredentialBuilder setAccessToken(@Nullable String string) {
            this.zzc = string;
            return this;
        }

        @NonNull
        public CredentialBuilder setIdToken(@Nullable String string) {
            this.zzb = string;
            return this;
        }

        @NonNull
        public CredentialBuilder setIdTokenWithRawNonce(@NonNull String string, @Nullable String string2) {
            this.zzb = string;
            this.zzd = string2;
            return this;
        }

        @KeepForSdk
        @Nullable
        public String getAccessToken() {
            return this.zzc;
        }

        @KeepForSdk
        @Nullable
        public String getIdToken() {
            return this.zzb;
        }

        private CredentialBuilder(String string) {
            this.zza = string;
        }

        /* synthetic */ CredentialBuilder(String string, zzal zzal2) {
            this(string);
        }
    }
}

