/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzil;
import com.google.android.gms.internal.firebase-auth-api.zzpe;
import com.google.android.gms.internal.firebase-auth-api.zzxm;
import com.google.android.gms.internal.firebase-auth-api.zzys;
import com.google.android.gms.internal.firebase-auth-api.zzzb;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzxn
implements zzys {
    private static final zzil.zza zza = zzil.zza.zzb;
    private static final ThreadLocal<Cipher> zzb = new zzxm();
    private final SecretKeySpec zzc;
    private final int zzd;
    private final int zze;

    public zzxn(byte[] byArray, int n) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use AES-CTR in FIPS-mode, as BoringCrypto module is not available.");
        }
        zzzb.zza(byArray.length);
        this.zzc = new SecretKeySpec(byArray, "AES");
        this.zze = zzb.get().getBlockSize();
        if (n < 12 || n > this.zze) {
            throw new GeneralSecurityException("invalid IV size");
        }
        this.zzd = n;
    }

    private final void zza(byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte[] byArray3, boolean bl) throws GeneralSecurityException {
        Cipher cipher = zzb.get();
        byte[] byArray4 = new byte[this.zze];
        System.arraycopy(byArray3, 0, byArray4, 0, this.zzd);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
        if (bl) {
            cipher.init(1, (Key)this.zzc, ivParameterSpec);
        } else {
            cipher.init(2, (Key)this.zzc, ivParameterSpec);
        }
        if (cipher.doFinal(byArray, n, n2, byArray2, n3) != n2) {
            throw new GeneralSecurityException("stored output's length does not match input's length");
        }
    }

    @Override
    public final byte[] zza(byte[] byArray) throws GeneralSecurityException {
        if (byArray.length < this.zzd) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        byte[] byArray2 = new byte[this.zzd];
        System.arraycopy(byArray, 0, byArray2, 0, this.zzd);
        byte[] byArray3 = new byte[byArray.length - this.zzd];
        this.zza(byArray, this.zzd, byArray.length - this.zzd, byArray3, 0, byArray2, false);
        return byArray3;
    }

    @Override
    public final byte[] zzb(byte[] byArray) throws GeneralSecurityException {
        if (byArray.length > Integer.MAX_VALUE - this.zzd) {
            int n = Integer.MAX_VALUE - this.zzd;
            throw new GeneralSecurityException("plaintext length can not exceed " + n);
        }
        byte[] byArray2 = new byte[this.zzd + byArray.length];
        byte[] byArray3 = zzpe.zza(this.zzd);
        System.arraycopy(byArray3, 0, byArray2, 0, this.zzd);
        this.zza(byArray, 0, byArray.length, byArray2, this.zzd, byArray3, true);
        return byArray2;
    }
}

