/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzmn;
import com.google.android.gms.internal.firebase-auth-api.zzpe;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public final class zzmk {
    public static final ECParameterSpec zza = zzmk.zza("115792089210356248762697446949407573530086143415290314195533631308867097853951", "115792089210356248762697446949407573529996955224135760342422259061068512044369", "5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", "6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", "4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5");
    public static final ECParameterSpec zzb = zzmk.zza("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319", "39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643", "b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef", "aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", "3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f");
    public static final ECParameterSpec zzc = zzmk.zza("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151", "6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449", "051953eb9618e1c9a1f929a21a0b68540eea2da725b99b315f3b8b489918ef109e156193951ec7e937b1652c0bd3bb1bf073573df883d2c34f1ef451fd46b503f00", "c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", "11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650");
    private static final BigInteger zzd = BigInteger.valueOf(2L);
    private static final BigInteger zze = BigInteger.valueOf(3L);
    private static final BigInteger zzf = BigInteger.valueOf(4L);
    private static final BigInteger zzg = BigInteger.valueOf(8L);

    private static zzmn zza(zzmn zzmn2, zzmn zzmn3, BigInteger bigInteger, BigInteger bigInteger2) {
        if (zzmn2.zza()) {
            return zzmn3;
        }
        if (zzmn3.zza()) {
            return zzmn2;
        }
        BigInteger bigInteger3 = zzmn2.zzd.multiply(zzmn2.zzd).mod(bigInteger2);
        BigInteger bigInteger4 = zzmn3.zzd.multiply(zzmn3.zzd).mod(bigInteger2);
        BigInteger bigInteger5 = zzmn2.zzb.multiply(bigInteger4).mod(bigInteger2);
        BigInteger bigInteger6 = zzmn3.zzb.multiply(bigInteger3).mod(bigInteger2);
        BigInteger bigInteger7 = zzmn2.zzc.multiply(zzmn3.zzd).mod(bigInteger2).multiply(bigInteger4).mod(bigInteger2);
        BigInteger bigInteger8 = zzmn3.zzc.multiply(zzmn2.zzd).mod(bigInteger2).multiply(bigInteger3).mod(bigInteger2);
        if (bigInteger5.equals(bigInteger6)) {
            if (!bigInteger7.equals(bigInteger8)) {
                return zzmn.zza;
            }
            return zzmk.zza(zzmn2, bigInteger, bigInteger2);
        }
        BigInteger bigInteger9 = bigInteger6.subtract(bigInteger5).mod(bigInteger2);
        BigInteger bigInteger10 = bigInteger9.multiply(zzf).multiply(bigInteger9).mod(bigInteger2);
        BigInteger bigInteger11 = bigInteger9.multiply(bigInteger10).mod(bigInteger2);
        BigInteger bigInteger12 = bigInteger8.subtract(bigInteger7).multiply(zzd).mod(bigInteger2);
        BigInteger bigInteger13 = bigInteger5.multiply(bigInteger10).mod(bigInteger2);
        BigInteger bigInteger14 = bigInteger12.multiply(bigInteger12).mod(bigInteger2).subtract(bigInteger11).subtract(bigInteger13.multiply(zzd)).mod(bigInteger2);
        BigInteger bigInteger15 = bigInteger12.multiply(bigInteger13.subtract(bigInteger14)).subtract(bigInteger7.multiply(zzd).multiply(bigInteger11)).mod(bigInteger2);
        BigInteger bigInteger16 = zzmn2.zzd.add(zzmn3.zzd);
        BigInteger bigInteger17 = bigInteger16.multiply(bigInteger16).mod(bigInteger2).subtract(bigInteger3).subtract(bigInteger4).multiply(bigInteger9).mod(bigInteger2);
        return new zzmn(bigInteger14, bigInteger15, bigInteger17);
    }

    private static zzmn zza(zzmn zzmn2, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        if (zzmn2.zzc.equals(BigInteger.ZERO)) {
            return zzmn.zza;
        }
        BigInteger bigInteger4 = zzmn2.zzb.multiply(zzmn2.zzb).mod(bigInteger2);
        BigInteger bigInteger5 = zzmn2.zzc.multiply(zzmn2.zzc).mod(bigInteger2);
        BigInteger bigInteger6 = bigInteger5.multiply(bigInteger5).mod(bigInteger2);
        BigInteger bigInteger7 = zzmn2.zzd.multiply(zzmn2.zzd).mod(bigInteger2);
        BigInteger bigInteger8 = zzmn2.zzb.add(bigInteger5);
        BigInteger bigInteger9 = bigInteger8.multiply(bigInteger8).mod(bigInteger2).subtract(bigInteger4).subtract(bigInteger6).multiply(zzd);
        BigInteger bigInteger10 = bigInteger4.multiply(zze).add(bigInteger.multiply(bigInteger7).multiply(bigInteger7).mod(bigInteger2));
        BigInteger bigInteger11 = bigInteger3 = bigInteger10.multiply(bigInteger10).mod(bigInteger2).subtract(bigInteger9.multiply(zzd)).mod(bigInteger2);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger9.subtract(bigInteger3)).mod(bigInteger2).subtract(bigInteger6.multiply(zzg)).mod(bigInteger2);
        BigInteger bigInteger13 = zzmn2.zzc.add(zzmn2.zzd);
        BigInteger bigInteger14 = bigInteger13.multiply(bigInteger13).mod(bigInteger2).subtract(bigInteger5).subtract(bigInteger7).mod(bigInteger2);
        return new zzmn(bigInteger11, bigInteger12, bigInteger14);
    }

    private static zzmn zza(ECPoint eCPoint, BigInteger bigInteger) {
        if (eCPoint.equals(ECPoint.POINT_INFINITY)) {
            return zzmn.zza;
        }
        BigInteger bigInteger2 = new BigInteger(1, zzpe.zza((bigInteger.bitLength() + 8) / 8)).mod(bigInteger);
        BigInteger bigInteger3 = bigInteger2.multiply(bigInteger2).mod(bigInteger);
        BigInteger bigInteger4 = bigInteger3.multiply(bigInteger2).mod(bigInteger);
        return new zzmn(eCPoint.getAffineX().multiply(bigInteger3).mod(bigInteger), eCPoint.getAffineY().multiply(bigInteger4).mod(bigInteger), bigInteger2);
    }

    public static BigInteger zza(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        ECField eCField = ellipticCurve.getField();
        if (eCField instanceof ECFieldFp) {
            return ((ECFieldFp)eCField).getP();
        }
        throw new GeneralSecurityException("Only curves over prime order fields are supported");
    }

    private static ECParameterSpec zza(String string, String string2, String string3, String string4, String string5) {
        BigInteger bigInteger = new BigInteger(string);
        BigInteger bigInteger2 = new BigInteger(string2);
        BigInteger bigInteger3 = new BigInteger("3");
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger3);
        BigInteger bigInteger5 = new BigInteger(string3, 16);
        BigInteger bigInteger6 = new BigInteger(string4, 16);
        BigInteger bigInteger7 = new BigInteger(string5, 16);
        ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
        EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, bigInteger4, bigInteger5);
        ECPoint eCPoint = new ECPoint(bigInteger6, bigInteger7);
        return new ECParameterSpec(ellipticCurve, eCPoint, bigInteger2, 1);
    }

    public static ECPoint zza(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws GeneralSecurityException {
        ECPoint eCPoint;
        Object object = eCParameterSpec;
        if (!(zzmk.zza((ECParameterSpec)object, zza) || zzmk.zza((ECParameterSpec)object, zzb) || zzmk.zza((ECParameterSpec)object, zzc))) {
            throw new GeneralSecurityException("spec must be NIST P256, P384 or P521");
        }
        if (bigInteger.signum() != 1) {
            throw new GeneralSecurityException("k must be positive");
        }
        if (bigInteger.compareTo(eCParameterSpec.getOrder()) >= 0) {
            throw new GeneralSecurityException("k must be smaller than the order of the generator");
        }
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        ECPoint eCPoint2 = eCParameterSpec.getGenerator();
        zzmk.zza(eCPoint2, ellipticCurve);
        BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
        BigInteger bigInteger3 = zzmk.zza(ellipticCurve);
        zzmn zzmn2 = zzmk.zza(ECPoint.POINT_INFINITY, bigInteger3);
        zzmn zzmn3 = zzmk.zza(eCPoint2, bigInteger3);
        for (int i = bigInteger.bitLength(); i >= 0; --i) {
            if (bigInteger.testBit(i)) {
                zzmn2 = zzmk.zza(zzmn2, zzmn3, bigInteger2, bigInteger3);
                zzmn3 = zzmk.zza(zzmn3, bigInteger2, bigInteger3);
                continue;
            }
            zzmn3 = zzmk.zza(zzmn2, zzmn3, bigInteger2, bigInteger3);
            zzmn2 = zzmk.zza(zzmn2, bigInteger2, bigInteger3);
        }
        BigInteger bigInteger4 = bigInteger3;
        object = zzmn2;
        if (((zzmn)object).zza()) {
            eCPoint = ECPoint.POINT_INFINITY;
        } else {
            BigInteger bigInteger5 = ((zzmn)object).zzd.modInverse(bigInteger4);
            BigInteger bigInteger6 = bigInteger5.multiply(bigInteger5).mod(bigInteger4);
            eCPoint = new ECPoint(((zzmn)object).zzb.multiply(bigInteger6).mod(bigInteger4), ((zzmn)object).zzc.multiply(bigInteger6).mod(bigInteger4).multiply(bigInteger5).mod(bigInteger4));
        }
        ECPoint eCPoint3 = eCPoint;
        zzmk.zza(eCPoint, ellipticCurve);
        return eCPoint3;
    }

    public static void zza(ECPoint eCPoint, EllipticCurve ellipticCurve) throws GeneralSecurityException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = zzmk.zza(ellipticCurve);
        BigInteger bigInteger3 = eCPoint.getAffineX();
        BigInteger bigInteger4 = eCPoint.getAffineY();
        if (bigInteger3 == null || bigInteger4 == null) {
            throw new GeneralSecurityException("point is at infinity");
        }
        if (bigInteger3.signum() == -1 || bigInteger3.compareTo(bigInteger2) >= 0) {
            throw new GeneralSecurityException("x is out of range");
        }
        if (bigInteger4.signum() == -1 || bigInteger4.compareTo(bigInteger2) >= 0) {
            throw new GeneralSecurityException("y is out of range");
        }
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger4).mod(bigInteger2);
        if (!bigInteger5.equals(bigInteger = bigInteger3.multiply(bigInteger3).add(ellipticCurve.getA()).multiply(bigInteger3).add(ellipticCurve.getB()).mod(bigInteger2))) {
            throw new GeneralSecurityException("Point is not on curve");
        }
    }

    public static boolean zza(ECParameterSpec eCParameterSpec, ECParameterSpec eCParameterSpec2) {
        return eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator()) && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder()) && eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor();
    }
}

