/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzajy;
import com.google.android.gms.internal.firebase-auth-api.zzami;
import com.google.android.gms.internal.firebase-auth-api.zzang;
import com.google.android.gms.internal.firebase-auth-api.zzbe;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nullable;

public final class zzane {
    private static final ThreadLocal<SimpleDateFormat> zza;

    private static long zzb(String string) throws ParseException {
        int n = string.indexOf(58);
        if (n == -1) {
            String string2 = string;
            throw new ParseException("Invalid offset value: " + string2, 0);
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        try {
            return (Long.parseLong(string3) * 60L + Long.parseLong(string4)) * 60L;
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = string;
            ParseException parseException = new ParseException("Invalid offset value: " + string5, 0);
            parseException.initCause(numberFormatException);
            throw parseException;
        }
    }

    public static long zza(zzami zzami2) {
        return zzane.zzb(zzami2).zzb();
    }

    private static zzami zzb(zzami zzami2) {
        int n;
        long l = zzami2.zzb();
        int n2 = n = zzami2.zza();
        if (!(!zzane.zza(l) ? false : n2 >= 0 && n2 < 1000000000)) {
            throw new IllegalArgumentException(String.format("Timestamp is not valid. See proto definition for valid values. Seconds (%s) must be in range [-62,135,596,800, +253,402,300,799]. Nanos (%s) must be in range [0, +999,999,999].", l, n));
        }
        return zzami2;
    }

    public static zzami zza(String string) throws ParseException {
        int n;
        int n2;
        int n3;
        String string2;
        int n4 = string.indexOf(84);
        if (n4 == -1) {
            String string3 = string;
            throw new ParseException("Failed to parse timestamp: invalid timestamp \"" + string3 + "\"", 0);
        }
        int n5 = string.indexOf(90, n4);
        if (n5 == -1) {
            n5 = string.indexOf(43, n4);
        }
        if (n5 == -1) {
            n5 = string.indexOf(45, n4);
        }
        if (n5 == -1) {
            throw new ParseException("Failed to parse timestamp: missing valid timezone offset.", 0);
        }
        String string4 = string2 = string.substring(0, n5);
        String string5 = "";
        int n6 = string2.indexOf(46);
        if (n6 != -1) {
            string4 = string2.substring(0, n6);
            string5 = string2.substring(n6 + 1);
        }
        long l = zza.get().parse(string4).getTime() / 1000L;
        if (string5.isEmpty()) {
            n3 = 0;
        } else {
            String string6 = string5;
            int n7 = 0;
            for (n2 = 0; n2 < 9; ++n2) {
                n7 *= 10;
                if (n2 >= string6.length()) continue;
                if (string6.charAt(n2) < '0' || string6.charAt(n2) > '9') {
                    throw new ParseException("Invalid nanoseconds.", 0);
                }
                n7 += string6.charAt(n2) - 48;
            }
            n3 = n = n7;
        }
        if (string.charAt(n5) == 'Z') {
            if (string.length() != n5 + 1) {
                String string7 = string.substring(n5);
                throw new ParseException("Failed to parse timestamp: invalid trailing data \"" + string7 + "\"", 0);
            }
        } else {
            long l2 = zzane.zzb(string.substring(n5 + 1));
            l = string.charAt(n5) == '+' ? (l -= l2) : (l += l2);
        }
        try {
            n2 = n;
            long l3 = l;
            if (!zzane.zza(l3)) {
                throw new IllegalArgumentException(String.format("Timestamp is not valid. Input seconds is too large. Seconds (%s) must be in range [-62,135,596,800, +253,402,300,799]. ", l3));
            }
            if (n2 <= -1000000000 || n2 >= 1000000000) {
                l3 = zzbe.zza(l3, n2 / 1000000000);
                n2 %= 1000000000;
            }
            if (n2 < 0) {
                n2 += 1000000000;
                l3 = zzbe.zzb(l3, 1L);
            }
            return zzane.zzb((zzami)((zzajy)zzami.zzc().zza(l3).zza(n2).zze()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string8 = string;
            ParseException parseException = new ParseException("Failed to parse timestamp " + string8 + " Timestamp is out of range.", 0);
            parseException.initCause(illegalArgumentException);
            throw parseException;
        }
    }

    @Nullable
    private static Method zzc(String string) {
        try {
            return Class.forName("java.time.Instant").getMethod(string, new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ SimpleDateFormat zza() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        simpleDateFormat.setCalendar(gregorianCalendar);
        return simpleDateFormat;
    }

    static {
        zzami cfr_ignored_0 = (zzami)((zzajy)zzami.zzc().zza(-62135596800L).zza(0).zze());
        zzami cfr_ignored_1 = (zzami)((zzajy)zzami.zzc().zza(253402300799L).zza(999999999).zze());
        zzami cfr_ignored_2 = (zzami)((zzajy)zzami.zzc().zza(0L).zza(0).zze());
        zza = new zzang();
        zzane.zzc("now");
        zzane.zzc("getEpochSecond");
        zzane.zzc("getNano");
    }

    private static boolean zza(long l) {
        return l >= -62135596800L && l <= 253402300799L;
    }
}

