/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzb;
import com.google.android.gms.internal.firebase-auth-api.zzf;
import com.google.android.gms.internal.firebase-auth-api.zzo;
import com.google.android.gms.internal.firebase-auth-api.zzwc;
import com.google.android.gms.internal.firebase-auth-api.zzxs;
import com.google.android.gms.internal.firebase-auth-api.zzxt;
import com.google.android.gms.internal.firebase-auth-api.zzxv;
import com.google.android.gms.internal.firebase-auth-api.zzxw;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.PhoneAuthCredential;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzxx {
    private static final Logger zza;
    private final Context zzb;
    private final ScheduledExecutorService zzc;
    private final HashMap zzd;

    static /* bridge */ /* synthetic */ Logger zza() {
        return zza;
    }

    @VisibleForTesting
    static String zzb(String object) {
        object = Pattern.compile("(?<!\\d)\\d{6}(?!\\d)").matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String zzc() {
        try {
            void var0_2;
            String string;
            String string2 = this.zzb.getPackageName();
            int n = Build.VERSION.SDK_INT;
            if (n < 28) {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)64).signatures;
            } else {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)0x8000000).signingInfo.getApkContentsSigners();
            }
            if ((string = zzxx.zzm(string2, var0_2[0].toCharsString())) != null) {
                return string;
            }
            zza.e("Hash generation failed.", new Object[0]);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.e("Unable to find package to obtain hash.", new Object[0]);
            return null;
        }
    }

    private static String zzm(String string, String string2) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append(string);
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append(string2);
        string2 = ((StringBuilder)object).toString();
        try {
            object = MessageDigest.getInstance("SHA-256");
            ((MessageDigest)object).update(string2.getBytes(zzo.zzc));
            string2 = Base64.encodeToString((byte[])Arrays.copyOf(((MessageDigest)object).digest(), 9), (int)3).substring(0, 11);
            object = zza;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Package: ");
            stringBuilder.append(string);
            stringBuilder.append(" -- Hash: ");
            stringBuilder.append(string2);
            object.d(stringBuilder.toString(), new Object[0]);
            return string2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            zza.e("NoSuchAlgorithm: ".concat(String.valueOf(noSuchAlgorithmException.getMessage())), new Object[0]);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ HashMap zzd(zzxx zzxx2) {
        return zzxx2.zzd;
    }

    static /* bridge */ /* synthetic */ void zze(zzxx object, String object2) {
        object = (zzxw)((zzxx)object).zzd.get(object2);
        if (object == null || zzag.zzd(((zzxw)object).zzd) || zzag.zzd(((zzxw)object).zze) || ((zzxw)object).zzb.isEmpty()) {
            return;
        }
        object2 = ((zzxw)object).zzb.iterator();
        while (object2.hasNext()) {
            ((zzwc)object2.next()).zzo(PhoneAuthCredential.zzc(((zzxw)object).zzd, ((zzxw)object).zze));
        }
        ((zzxw)object).zzh = true;
    }

    static /* bridge */ /* synthetic */ void zzf(zzxx zzxx2, String string) {
        zzxx2.zzn(string);
    }

    static /* bridge */ /* synthetic */ void zzg(zzxx zzxx2, String string) {
        zzxx2.zzo(string);
    }

    static {
        Logger logger;
        String[] stringArray = new String[]{"SmsRetrieverHelper"};
        zza = logger = new Logger("FirebaseAuth", stringArray);
    }

    zzxx(@NonNull Context context) {
        HashMap hashMap;
        this.zzd = hashMap = new HashMap();
        this.zzb = (Context)Preconditions.checkNotNull((Object)context);
        zzf.zza();
        this.zzc = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    final /* synthetic */ void zzh(String string) {
        this.zzo(string);
    }

    private final void zzn(String object) {
        zzxw zzxw2 = (zzxw)((zzxx)((Object)zzxw2)).zzd.get(object);
        if (zzxw2 == null) {
            return;
        }
        if (!zzxw2.zzh && !zzag.zzd(zzxw2.zzd)) {
            zza.w("Timed out waiting for SMS.", new Object[0]);
            object = zzxw2.zzb.iterator();
            while (object.hasNext()) {
                ((zzwc)object.next()).zza(zzxw2.zzd);
            }
            zzxw2.zzi = true;
            return;
        }
    }

    private final void zzo(String string) {
        zzxw zzxw2 = (zzxw)this.zzd.get(string);
        if (zzxw2 == null) {
            return;
        }
        if (!zzxw2.zzi) {
            this.zzn(string);
        }
        this.zzj(string);
    }

    final void zzi(zzwc zzwc2, String string) {
        zzxw zzxw2 = (zzxw)((zzxx)((Object)zzxw2)).zzd.get(string);
        if (zzxw2 == null) {
            return;
        }
        zzxw2.zzb.add(zzwc2);
        if (zzxw2.zzg) {
            zzwc2.zzb(zzxw2.zzd);
        }
        if (zzxw2.zzh) {
            zzwc2.zzo(PhoneAuthCredential.zzc(zzxw2.zzd, zzxw2.zze));
        }
        if (zzxw2.zzi) {
            zzwc2.zza(zzxw2.zzd);
            return;
        }
    }

    final void zzj(String string) {
        zzxw zzxw2 = (zzxw)this.zzd.get(string);
        if (zzxw2 == null) {
            return;
        }
        ScheduledFuture scheduledFuture = zzxw2.zzf;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            zzxw2.zzf.cancel(false);
        }
        zzxw2.zzb.clear();
        this.zzd.remove(string);
    }

    final void zzk(String string, zzwc object, long l, boolean bl) {
        Object object2 = this.zzd;
        zzxw zzxw2 = new zzxw(l, bl);
        ((HashMap)object2).put(string, zzxw2);
        this.zzi((zzwc)object, string);
        object = (zzxw)this.zzd.get(string);
        long l2 = ((zzxw)object).zza;
        if (l2 <= 0L) {
            zza.w("Timeout of 0 specified; SmsRetriever will not start.", new Object[0]);
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this.zzc;
        object2 = new zzxs(this, string);
        ((zzxw)object).zzf = scheduledExecutorService.schedule((Runnable)object2, l2, TimeUnit.SECONDS);
        if (!((zzxw)object).zzc) {
            zza.w("SMS auto-retrieval unavailable; SmsRetriever will not start.", new Object[0]);
            return;
        }
        object = new zzxv(this, string);
        string = new IntentFilter();
        string.addAction("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        com.google.android.gms.internal.firebase-auth-api.zzb.zza(this.zzb.getApplicationContext(), (BroadcastReceiver)object, (IntentFilter)string);
        string = this.zzb;
        string = SmsRetriever.getClient((Context)string);
        string = string.startSmsRetriever();
        object = new zzxt(this);
        string.addOnFailureListener((OnFailureListener)object);
    }

    final boolean zzl(String string) {
        return this.zzd.get(string) != null;
    }
}

