/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzwv;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzt;
import com.google.firebase.auth.zzw;
import com.google.firebase.auth.zzx;
import com.google.firebase.auth.zzy;
import java.util.List;

public abstract class FirebaseUser
extends AbstractSafeParcelable
implements UserInfo {
    @Override
    @NonNull
    public abstract String getUid();

    @Override
    @NonNull
    public abstract String getProviderId();

    public abstract boolean isAnonymous();

    @NonNull
    public abstract List<? extends UserInfo> getProviderData();

    @Override
    @Nullable
    public abstract String getDisplayName();

    @Override
    @Nullable
    public abstract Uri getPhotoUrl();

    @Override
    @Nullable
    public abstract String getEmail();

    @Override
    @Nullable
    public abstract String getPhoneNumber();

    @Nullable
    public abstract String getTenantId();

    @NonNull
    public Task<GetTokenResult> getIdToken(boolean bl) {
        return FirebaseAuth.getInstance(this.zzd()).zzg(this, bl);
    }

    @NonNull
    public Task<Void> reload() {
        FirebaseAuth firebaseAuth = FirebaseAuth.getInstance(this.zzd());
        zzt zzt2 = new zzt(firebaseAuth);
        return firebaseAuth.zzl(this, zzt2);
    }

    @NonNull
    public Task<Void> reauthenticate(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzd()).zzh(this, authCredential);
    }

    @NonNull
    public Task<AuthResult> reauthenticateAndRetrieveData(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzd()).zzi(this, authCredential);
    }

    @NonNull
    public Task<AuthResult> startActivityForReauthenticateWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        return FirebaseAuth.getInstance(this.zzd()).zzw(activity, federatedAuthProvider, this);
    }

    @NonNull
    public Task<AuthResult> linkWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzd()).zzm(this, authCredential);
    }

    @NonNull
    public Task<AuthResult> startActivityForLinkWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        return FirebaseAuth.getInstance(this.zzd()).zzv(activity, federatedAuthProvider, this);
    }

    @NonNull
    public Task<AuthResult> unlink(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzd()).zzn(this, string);
    }

    @NonNull
    public Task<Void> updateProfile(@NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return FirebaseAuth.getInstance(this.zzd()).zzo(this, userProfileChangeRequest);
    }

    @NonNull
    public Task<Void> updateEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzd()).zzp(this, string);
    }

    @NonNull
    public Task<Void> updatePhoneNumber(@NonNull PhoneAuthCredential phoneAuthCredential) {
        return FirebaseAuth.getInstance(this.zzd()).zzq(this, phoneAuthCredential);
    }

    @NonNull
    public Task<Void> updatePassword(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzd()).zzr(this, string);
    }

    @NonNull
    public Task<Void> delete() {
        return FirebaseAuth.getInstance(this.zzd()).zzx(this);
    }

    @NonNull
    public Task<Void> sendEmailVerification() {
        Object object = this.zzd();
        object = FirebaseAuth.getInstance((FirebaseApp)object);
        object = ((FirebaseAuth)object).zzg(this, false);
        zzw zzw2 = new zzw(this);
        return object.continueWithTask((Continuation)zzw2);
    }

    @NonNull
    public Task<Void> sendEmailVerification(@NonNull ActionCodeSettings actionCodeSettings) {
        Object object = this.zzd();
        object = FirebaseAuth.getInstance((FirebaseApp)object);
        object = ((FirebaseAuth)object).zzg(this, false);
        zzx zzx2 = new zzx(this, actionCodeSettings);
        return object.continueWithTask((Continuation)zzx2);
    }

    @Nullable
    public abstract FirebaseUserMetadata getMetadata();

    @NonNull
    public abstract MultiFactor getMultiFactor();

    @NonNull
    public Task<Void> verifyBeforeUpdateEmail(@NonNull String string) {
        return this.verifyBeforeUpdateEmail(string, null);
    }

    @NonNull
    public Task<Void> verifyBeforeUpdateEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        Object object = this.zzd();
        object = FirebaseAuth.getInstance((FirebaseApp)object);
        object = ((FirebaseAuth)object).zzg(this, false);
        zzy zzy2 = new zzy(this, string, actionCodeSettings);
        return object.continueWithTask((Continuation)zzy2);
    }

    @Nullable
    public abstract List<String> zza();

    @NonNull
    public abstract FirebaseUser zzb(@NonNull List<? extends UserInfo> var1);

    public abstract FirebaseUser zzc();

    @NonNull
    public abstract FirebaseApp zzd();

    @NonNull
    public abstract zzwv zze();

    public abstract void zzf(@NonNull zzwv var1);

    @NonNull
    public abstract String zzg();

    @NonNull
    public abstract String zzh();

    public abstract void zzi(List<MultiFactorInfo> var1);
}

