/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.firebase_auth.zzdr;
import com.google.android.gms.internal.firebase_auth.zzz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.api.internal.zzds;
import com.google.firebase.auth.zzd;

public final class zzac {
    @VisibleForTesting
    private static long zzrr = 3600000L;
    private static final zzz<String> zzrs = zzz.zza("firebaseAppName", "firebaseUserUid", "operation", "tenantId", "verifyAssertionRequest", "statusCode", "statusMessage", "timestamp");
    private static final zzac zzrt = new zzac();
    private Task<AuthResult> zzru;
    private long zzrv = 0L;

    private zzac() {
    }

    public static zzac zzen() {
        return zzrt;
    }

    public static void zza(@NonNull Context context, @NonNull zzdr zzdr2, @NonNull String string, @Nullable String string2) {
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putString("verifyAssertionRequest", SafeParcelableSerializer.serializeToString((SafeParcelable)zzdr2));
        editor.putString("operation", string);
        editor.putString("tenantId", string2);
        editor.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
        editor.commit();
    }

    public static void zza(@NonNull Context context, @NonNull Status status) {
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putInt("statusCode", status.getStatusCode());
        editor.putString("statusMessage", status.getStatusMessage());
        editor.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
        editor.commit();
    }

    public final void zzh(@NonNull FirebaseAuth firebaseAuth) {
        Preconditions.checkNotNull((Object)firebaseAuth);
        SharedPreferences sharedPreferences = firebaseAuth.zzcc().getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0);
        String string = sharedPreferences.getString("firebaseAppName", "");
        if (!firebaseAuth.zzcc().getName().equals(string)) {
            return;
        }
        if (sharedPreferences.contains("verifyAssertionRequest")) {
            zzdr zzdr2 = (zzdr)SafeParcelableSerializer.deserializeFromString((String)sharedPreferences.getString("verifyAssertionRequest", ""), zzdr.CREATOR);
            String string2 = sharedPreferences.getString("operation", "");
            String string3 = sharedPreferences.getString("tenantId", null);
            this.zzrv = sharedPreferences.getLong("timestamp", 0L);
            String string4 = sharedPreferences.getString("firebaseUserUid", "");
            if (string3 != null) {
                firebaseAuth.zzc(string3);
            }
            switch (string2) {
                case "com.google.firebase.auth.internal.SIGN_IN": {
                    this.zzru = firebaseAuth.signInWithCredential(zzd.zza(zzdr2));
                    break;
                }
                case "com.google.firebase.auth.internal.LINK": {
                    if (firebaseAuth.getCurrentUser().getUid().equals(string4)) {
                        this.zzru = firebaseAuth.getCurrentUser().linkWithCredential(zzd.zza(zzdr2));
                        break;
                    }
                    this.zzru = null;
                    break;
                }
                case "com.google.firebase.auth.internal.REAUTHENTICATE": {
                    if (firebaseAuth.getCurrentUser().getUid().equals(string4)) {
                        this.zzru = firebaseAuth.getCurrentUser().reauthenticateAndRetrieveData(zzd.zza(zzdr2));
                        break;
                    }
                    this.zzru = null;
                    break;
                }
                default: {
                    this.zzru = null;
                }
            }
            zzac.zza(sharedPreferences);
            return;
        }
        if (sharedPreferences.contains("statusCode")) {
            int n = sharedPreferences.getInt("statusCode", 17062);
            String string5 = sharedPreferences.getString("statusMessage", "");
            Status status = new Status(n, string5);
            this.zzrv = sharedPreferences.getLong("timestamp", 0L);
            zzac.zza(sharedPreferences);
            this.zzru = Tasks.forException((Exception)zzds.zzb(status));
            return;
        }
    }

    public final void zza(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        zzac.zza(context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0));
        this.zzru = null;
        this.zzrv = 0L;
    }

    private static void zza(@NonNull SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        zzz<String> zzz2 = zzrs;
        int n = zzz2.size();
        for (int i = 0; i < n; ++i) {
            Object e = zzz2.get(i);
            String string = (String)e;
            editor.remove(string);
        }
        editor.commit();
    }
}

