/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcke;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzclz;
import com.google.android.gms.internal.zzcmb;
import com.google.android.gms.internal.zzcmc;
import com.google.android.gms.internal.zzcmd;
import com.google.android.gms.internal.zzcno;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzcma
extends zzcli {
    protected zzcmd zzjqm;
    private volatile zzclz zzjqn;
    private zzclz zzjqo;
    private long zzjqp;
    private final Map<Activity, zzcmd> zzjqq = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzjqr = new CopyOnWriteArrayList();
    private boolean zzjqs;
    private zzclz zzjqt;
    private String zzjqu;

    public zzcma(zzckj zzckj2) {
        super(zzckj2);
    }

    @Override
    protected final boolean zzazq() {
        return false;
    }

    @WorkerThread
    public final zzcmd zzbcg() {
        this.zzyk();
        ((zzclh)this).zzwj();
        return this.zzjqm;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        ((zzclh)this).zzayo();
        if (!zzcke.zzas()) {
            ((zzclh)this).zzayp().zzbaw().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzjqs) {
            ((zzclh)this).zzayp().zzbaw().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzjqn == null) {
            ((zzclh)this).zzayp().zzbaw().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzjqq.get(activity) == null) {
            ((zzclh)this).zzayp().zzbaw().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzcma.zzkg(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzjqn.zzjqk.equals(string2);
        boolean bl2 = zzcno.zzas(this.zzjqn.zzjqj, string);
        if (bl && bl2) {
            ((zzclh)this).zzayp().zzbax().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzclh)this).zzayp().zzbaw().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzclh)this).zzayp().zzbaw().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzclh)this).zzayp().zzbba().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcmd zzcmd2 = new zzcmd(string, string2, ((zzclh)this).zzayl().zzbcq());
        this.zzjqq.put(activity, zzcmd2);
        this.zza(activity, zzcmd2, true);
    }

    public final zzclz zzbch() {
        zzclz zzclz2 = this.zzjqn;
        if (zzclz2 == null) {
            return null;
        }
        return new zzclz(zzclz2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        if (zza2 == null) {
            ((zzclh)this).zzayp().zzbaw().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzjqr.remove(zza2);
        this.zzjqr.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        this.zzjqr.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcmd zzcmd2, boolean bl) {
        Object object;
        Object object2;
        zzclz zzclz2 = null;
        if (this.zzjqn != null) {
            zzclz2 = this.zzjqn;
        } else if (this.zzjqo != null && Math.abs(((zzclh)this).zzxx().elapsedRealtime() - this.zzjqp) < 1000L) {
            zzclz2 = this.zzjqo;
        }
        zzclz zzclz3 = null;
        if (zzclz2 != null) {
            zzclz3 = new zzclz(zzclz2);
        }
        boolean bl2 = true;
        this.zzjqs = true;
        try {
            object2 = this.zzjqr.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzclz3, zzcmd2);
                }
                catch (Exception exception) {
                    ((zzclh)this).zzayp().zzbau().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzclh)this).zzayp().zzbau().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzjqs = false;
        }
        Object object3 = object2 = this.zzjqn == null ? this.zzjqo : this.zzjqn;
        if (bl2) {
            if (zzcmd2.zzjqk == null) {
                zzcmd2.zzjqk = zzcma.zzkg(activity.getClass().getCanonicalName());
            }
            object = new zzcmd(zzcmd2);
            this.zzjqo = this.zzjqn;
            this.zzjqp = ((zzclh)this).zzxx().elapsedRealtime();
            this.zzjqn = object;
            ((zzclh)this).zzayo().zzh(new zzcmb(this, bl, (zzclz)object2, (zzcmd)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcmd zzcmd2) {
        ((zzclh)this).zzayb().zzaj(((zzclh)this).zzxx().elapsedRealtime());
        if (((zzclh)this).zzayn().zzbx(zzcmd2.zzjra)) {
            zzcmd2.zzjra = false;
        }
    }

    public static void zza(zzclz zzclz2, Bundle bundle, boolean bl) {
        if (bundle != null && zzclz2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzclz2.zzjqj != null) {
                bundle.putString("_sn", zzclz2.zzjqj);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzclz2.zzjqk);
            bundle.putLong("_si", zzclz2.zzjql);
            return;
        }
        if (bundle != null && zzclz2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzclz zzclz2) {
        ((zzclh)this).zzwj();
        zzcma zzcma2 = this;
        synchronized (zzcma2) {
            if (this.zzjqu == null || this.zzjqu.equals(string) || zzclz2 != null) {
                this.zzjqu = string;
                this.zzjqt = zzclz2;
            }
            return;
        }
    }

    private static String zzkg(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    final zzcmd zzr(@NonNull Activity activity) {
        zzbq.checkNotNull((Object)activity);
        zzcmd zzcmd2 = this.zzjqq.get(activity);
        if (zzcmd2 == null) {
            String string = zzcma.zzkg(activity.getClass().getCanonicalName());
            zzcmd2 = new zzcmd(null, string, ((zzclh)this).zzayl().zzbcq());
            this.zzjqq.put(activity, zzcmd2);
        }
        return zzcmd2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcmd zzcmd2 = this.zzr(activity);
        this.zza(activity, zzcmd2, false);
        zzcia zzcia2 = ((zzclh)this).zzayb();
        long l = ((zzclh)zzcia2).zzxx().elapsedRealtime();
        ((zzclh)zzcia2).zzayo().zzh(new zzcid(zzcia2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcmd zzcmd2 = this.zzr(activity);
        this.zzjqo = this.zzjqn;
        this.zzjqp = ((zzclh)this).zzxx().elapsedRealtime();
        this.zzjqn = null;
        ((zzclh)this).zzayo().zzh(new zzcmc(this, zzcmd2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcmd zzcmd2 = this.zzjqq.get(activity);
        if (zzcmd2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcmd2.zzjql);
        bundle2.putString("name", zzcmd2.zzjqj);
        bundle2.putString("referrer_name", zzcmd2.zzjqk);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzjqq.remove(activity);
    }

    static /* synthetic */ void zza(zzcma zzcma2, zzcmd zzcmd2) {
        zzcma2.zza(zzcmd2);
    }
}

