/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Key;
import com.google.api.client.util.Sleeper;
import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.ErrorCode;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.projectmanagement.AndroidApp;
import com.google.firebase.projectmanagement.AndroidAppMetadata;
import com.google.firebase.projectmanagement.AndroidAppService;
import com.google.firebase.projectmanagement.FirebaseProjectManagementException;
import com.google.firebase.projectmanagement.HttpHelper;
import com.google.firebase.projectmanagement.IosApp;
import com.google.firebase.projectmanagement.IosAppMetadata;
import com.google.firebase.projectmanagement.IosAppService;
import com.google.firebase.projectmanagement.Scheduler;
import com.google.firebase.projectmanagement.ShaCertificate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

class FirebaseProjectManagementServiceImpl
implements AndroidAppService,
IosAppService {
    @VisibleForTesting
    static final String FIREBASE_PROJECT_MANAGEMENT_URL = "https://firebase.googleapis.com";
    @VisibleForTesting
    static final int MAXIMUM_LIST_APPS_PAGE_SIZE = 100;
    private static final int MAXIMUM_POLLING_ATTEMPTS = 7;
    private static final long POLL_BASE_WAIT_TIME_MILLIS = 500L;
    private static final double POLL_EXPONENTIAL_BACKOFF_FACTOR = 1.5;
    private static final String ANDROID_APPS_RESOURCE_NAME = "androidApps";
    private static final String IOS_APPS_RESOURCE_NAME = "iosApps";
    private static final String ANDROID_NAMESPACE_PROPERTY = "package_name";
    private static final String IOS_NAMESPACE_PROPERTY = "bundle_id";
    private final FirebaseApp app;
    private final Sleeper sleeper;
    private final Scheduler scheduler;
    private final HttpHelper httpHelper;
    private final CreateAndroidAppFromAppIdFunction createAndroidAppFromAppIdFunction = new CreateAndroidAppFromAppIdFunction();
    private final CreateIosAppFromAppIdFunction createIosAppFromAppIdFunction = new CreateIosAppFromAppIdFunction();

    FirebaseProjectManagementServiceImpl(FirebaseApp app) {
        this(app, Sleeper.DEFAULT, new FirebaseAppScheduler(app), ApiClientUtils.newAuthorizedRequestFactory(app));
    }

    @VisibleForTesting
    FirebaseProjectManagementServiceImpl(FirebaseApp app, Sleeper sleeper, Scheduler scheduler, HttpRequestFactory requestFactory) {
        this.app = (FirebaseApp)Preconditions.checkNotNull((Object)app);
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
        this.scheduler = (Scheduler)Preconditions.checkNotNull((Object)scheduler);
        this.httpHelper = new HttpHelper(app.getOptions().getJsonFactory(), requestFactory);
    }

    @VisibleForTesting
    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.httpHelper.setInterceptor(interceptor);
    }

    void destroy() {
    }

    @Override
    public AndroidAppMetadata getAndroidApp(String appId) throws FirebaseProjectManagementException {
        return this.getAndroidAppOp(appId).call();
    }

    @Override
    public ApiFuture<AndroidAppMetadata> getAndroidAppAsync(String appId) {
        return this.getAndroidAppOp(appId).callAsync(this.app);
    }

    private CallableOperation<AndroidAppMetadata, FirebaseProjectManagementException> getAndroidAppOp(final String appId) {
        return new CallableOperation<AndroidAppMetadata, FirebaseProjectManagementException>(){

            @Override
            protected AndroidAppMetadata execute() throws FirebaseProjectManagementException {
                String url = String.format("%s/v1beta1/projects/-/androidApps/%s", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, appId);
                AndroidAppResponse parsedResponse = new AndroidAppResponse();
                FirebaseProjectManagementServiceImpl.this.httpHelper.makeGetRequest(url, parsedResponse, appId, "App ID");
                return new AndroidAppMetadata(parsedResponse.name, parsedResponse.appId, Strings.emptyToNull((String)parsedResponse.displayName), parsedResponse.projectId, parsedResponse.packageName);
            }
        };
    }

    @Override
    public IosAppMetadata getIosApp(String appId) throws FirebaseProjectManagementException {
        return this.getIosAppOp(appId).call();
    }

    @Override
    public ApiFuture<IosAppMetadata> getIosAppAsync(String appId) {
        return this.getIosAppOp(appId).callAsync(this.app);
    }

    private CallableOperation<IosAppMetadata, FirebaseProjectManagementException> getIosAppOp(final String appId) {
        return new CallableOperation<IosAppMetadata, FirebaseProjectManagementException>(){

            @Override
            protected IosAppMetadata execute() throws FirebaseProjectManagementException {
                String url = String.format("%s/v1beta1/projects/-/iosApps/%s", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, appId);
                IosAppResponse parsedResponse = new IosAppResponse();
                FirebaseProjectManagementServiceImpl.this.httpHelper.makeGetRequest(url, parsedResponse, appId, "App ID");
                return new IosAppMetadata(parsedResponse.name, parsedResponse.appId, Strings.emptyToNull((String)parsedResponse.displayName), parsedResponse.projectId, parsedResponse.bundleId);
            }
        };
    }

    @Override
    public List<AndroidApp> listAndroidApps(String projectId) throws FirebaseProjectManagementException {
        return this.listAndroidAppsOp(projectId).call();
    }

    @Override
    public ApiFuture<List<AndroidApp>> listAndroidAppsAsync(String projectId) {
        return this.listAndroidAppsOp(projectId).callAsync(this.app);
    }

    @Override
    public List<IosApp> listIosApps(String projectId) throws FirebaseProjectManagementException {
        return this.listIosAppsOp(projectId).call();
    }

    @Override
    public ApiFuture<List<IosApp>> listIosAppsAsync(String projectId) {
        return this.listIosAppsOp(projectId).callAsync(this.app);
    }

    private CallableOperation<List<AndroidApp>, FirebaseProjectManagementException> listAndroidAppsOp(String projectId) {
        return this.listAppsOp(projectId, ANDROID_APPS_RESOURCE_NAME, this.createAndroidAppFromAppIdFunction);
    }

    private CallableOperation<List<IosApp>, FirebaseProjectManagementException> listIosAppsOp(String projectId) {
        return this.listAppsOp(projectId, IOS_APPS_RESOURCE_NAME, this.createIosAppFromAppIdFunction);
    }

    private <T> CallableOperation<List<T>, FirebaseProjectManagementException> listAppsOp(final String projectId, final String platformResourceName, final CreateAppFromAppIdFunction<T> createAppFromAppIdFunction) {
        return new CallableOperation<List<T>, FirebaseProjectManagementException>(){

            @Override
            protected List<T> execute() throws FirebaseProjectManagementException {
                ListAppsResponse parsedResponse;
                String url = String.format("%s/v1beta1/projects/%s/%s?page_size=%d", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, projectId, platformResourceName, 100);
                ImmutableList.Builder builder = ImmutableList.builder();
                do {
                    parsedResponse = new ListAppsResponse();
                    FirebaseProjectManagementServiceImpl.this.httpHelper.makeGetRequest(url, parsedResponse, projectId, "Project ID");
                    if (parsedResponse.apps == null) break;
                    for (AppResponse app : parsedResponse.apps) {
                        builder.add(createAppFromAppIdFunction.apply(app.appId));
                    }
                    url = String.format("%s/v1beta1/projects/%s/%s?page_token=%s&page_size=%d", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, projectId, platformResourceName, parsedResponse.nextPageToken, 100);
                } while (!Strings.isNullOrEmpty((String)parsedResponse.nextPageToken));
                return builder.build();
            }
        };
    }

    @Override
    public AndroidApp createAndroidApp(String projectId, String packageName, String displayName) throws FirebaseProjectManagementException {
        String operationName = this.createAndroidAppOp(projectId, packageName, displayName).call();
        String appId = this.pollOperation(projectId, operationName);
        return new AndroidApp(appId, this);
    }

    @Override
    public ApiFuture<AndroidApp> createAndroidAppAsync(String projectId, String packageName, String displayName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)packageName) ? 1 : 0) != 0, (Object)"package name must not be null or empty");
        return ImplFirebaseTrampolines.transform(ImplFirebaseTrampolines.transformAsync(this.createAndroidAppOp(projectId, packageName, displayName).callAsync(this.app), new WaitOperationFunction(projectId), this.app), this.createAndroidAppFromAppIdFunction, this.app);
    }

    @Override
    public IosApp createIosApp(String projectId, String bundleId, String displayName) throws FirebaseProjectManagementException {
        String operationName = this.createIosAppOp(projectId, bundleId, displayName).call();
        String appId = this.pollOperation(projectId, operationName);
        return new IosApp(appId, this);
    }

    @Override
    public ApiFuture<IosApp> createIosAppAsync(String projectId, String bundleId, String displayName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bundleId) ? 1 : 0) != 0, (Object)"bundle ID must not be null or empty");
        return ImplFirebaseTrampolines.transform(ImplFirebaseTrampolines.transformAsync(this.createIosAppOp(projectId, bundleId, displayName).callAsync(this.app), new WaitOperationFunction(projectId), this.app), this.createIosAppFromAppIdFunction, this.app);
    }

    private CallableOperation<String, FirebaseProjectManagementException> createAndroidAppOp(String projectId, String namespace, String displayName) {
        return this.createAppOp(projectId, namespace, displayName, ANDROID_NAMESPACE_PROPERTY, ANDROID_APPS_RESOURCE_NAME);
    }

    private CallableOperation<String, FirebaseProjectManagementException> createIosAppOp(String projectId, String namespace, String displayName) {
        return this.createAppOp(projectId, namespace, displayName, IOS_NAMESPACE_PROPERTY, IOS_APPS_RESOURCE_NAME);
    }

    private CallableOperation<String, FirebaseProjectManagementException> createAppOp(final String projectId, final String namespace, final String displayName, final String platformNamespaceProperty, final String platformResourceName) {
        return new CallableOperation<String, FirebaseProjectManagementException>(){

            @Override
            protected String execute() throws FirebaseProjectManagementException {
                String url = String.format("%s/v1beta1/projects/%s/%s", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, projectId, platformResourceName);
                ImmutableMap.Builder payloadBuilder = ImmutableMap.builder().put((Object)platformNamespaceProperty, (Object)namespace);
                if (!Strings.isNullOrEmpty((String)displayName)) {
                    payloadBuilder.put((Object)"display_name", (Object)displayName);
                }
                OperationResponse operationResponseInstance = new OperationResponse();
                IncomingHttpResponse response = FirebaseProjectManagementServiceImpl.this.httpHelper.makePostRequest(url, payloadBuilder.build(), operationResponseInstance, projectId, "Project ID");
                if (Strings.isNullOrEmpty((String)operationResponseInstance.name)) {
                    String message = FirebaseProjectManagementServiceImpl.this.buildMessage(namespace, "Bundle ID", "Unable to create App: server returned null operation name.");
                    throw new FirebaseProjectManagementException(ErrorCode.INTERNAL, message, response);
                }
                return operationResponseInstance.name;
            }
        };
    }

    private String pollOperation(String projectId, String operationName) throws FirebaseProjectManagementException {
        String url = String.format("%s/v1/%s", FIREBASE_PROJECT_MANAGEMENT_URL, operationName);
        for (int currentAttempt = 0; currentAttempt < 7; ++currentAttempt) {
            long delayMillis = (long)(500.0 * Math.pow(1.5, currentAttempt));
            this.sleepOrThrow(projectId, delayMillis);
            OperationResponse operationResponseInstance = new OperationResponse();
            IncomingHttpResponse response = this.httpHelper.makeGetRequest(url, operationResponseInstance, projectId, "Project ID");
            if (!operationResponseInstance.done) continue;
            if (operationResponseInstance.response == null || Strings.isNullOrEmpty((String)((OperationResponse)operationResponseInstance).response.appId)) {
                String message = this.buildMessage(projectId, "Project ID", "Unable to create App: internal server error.");
                throw new FirebaseProjectManagementException(ErrorCode.INTERNAL, message, response);
            }
            return ((OperationResponse)operationResponseInstance).response.appId;
        }
        String message = this.buildMessage(projectId, "Project ID", "Unable to create App: deadline exceeded.");
        throw new FirebaseProjectManagementException(ErrorCode.DEADLINE_EXCEEDED, message, null);
    }

    @Override
    public void setAndroidDisplayName(String appId, String newDisplayName) throws FirebaseProjectManagementException {
        this.setAndroidDisplayNameOp(appId, newDisplayName).call();
    }

    @Override
    public ApiFuture<Void> setAndroidDisplayNameAsync(String appId, String newDisplayName) {
        return this.setAndroidDisplayNameOp(appId, newDisplayName).callAsync(this.app);
    }

    @Override
    public void setIosDisplayName(String appId, String newDisplayName) throws FirebaseProjectManagementException {
        this.setIosDisplayNameOp(appId, newDisplayName).call();
    }

    @Override
    public ApiFuture<Void> setIosDisplayNameAsync(String appId, String newDisplayName) {
        return this.setIosDisplayNameOp(appId, newDisplayName).callAsync(this.app);
    }

    private CallableOperation<Void, FirebaseProjectManagementException> setAndroidDisplayNameOp(String appId, String newDisplayName) {
        return this.setDisplayNameOp(appId, newDisplayName, ANDROID_APPS_RESOURCE_NAME);
    }

    private CallableOperation<Void, FirebaseProjectManagementException> setIosDisplayNameOp(String appId, String newDisplayName) {
        return this.setDisplayNameOp(appId, newDisplayName, IOS_APPS_RESOURCE_NAME);
    }

    private CallableOperation<Void, FirebaseProjectManagementException> setDisplayNameOp(final String appId, final String newDisplayName, final String platformResourceName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)newDisplayName) ? 1 : 0) != 0, (Object)"new Display Name must not be null or empty");
        return new CallableOperation<Void, FirebaseProjectManagementException>(){

            @Override
            protected Void execute() throws FirebaseProjectManagementException {
                String url = String.format("%s/v1beta1/projects/-/%s/%s?update_mask=display_name", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, platformResourceName, appId);
                ImmutableMap payload = ImmutableMap.builder().put((Object)"display_name", (Object)newDisplayName).build();
                EmptyResponse emptyResponseInstance = new EmptyResponse();
                FirebaseProjectManagementServiceImpl.this.httpHelper.makePatchRequest(url, payload, emptyResponseInstance, appId, "App ID");
                return null;
            }
        };
    }

    @Override
    public String getAndroidConfig(String appId) throws FirebaseProjectManagementException {
        return this.getAndroidConfigOp(appId).call();
    }

    @Override
    public ApiFuture<String> getAndroidConfigAsync(String appId) {
        return this.getAndroidConfigOp(appId).callAsync(this.app);
    }

    @Override
    public String getIosConfig(String appId) throws FirebaseProjectManagementException {
        return this.getIosConfigOp(appId).call();
    }

    @Override
    public ApiFuture<String> getIosConfigAsync(String appId) {
        return this.getIosConfigOp(appId).callAsync(this.app);
    }

    private CallableOperation<String, FirebaseProjectManagementException> getAndroidConfigOp(String appId) {
        return this.getConfigOp(appId, ANDROID_APPS_RESOURCE_NAME);
    }

    private CallableOperation<String, FirebaseProjectManagementException> getIosConfigOp(String appId) {
        return this.getConfigOp(appId, IOS_APPS_RESOURCE_NAME);
    }

    private CallableOperation<String, FirebaseProjectManagementException> getConfigOp(final String appId, final String platformResourceName) {
        return new CallableOperation<String, FirebaseProjectManagementException>(){

            @Override
            protected String execute() throws FirebaseProjectManagementException {
                String url = String.format("%s/v1beta1/projects/-/%s/%s/config", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, platformResourceName, appId);
                AppConfigResponse parsedResponse = new AppConfigResponse();
                FirebaseProjectManagementServiceImpl.this.httpHelper.makeGetRequest(url, parsedResponse, appId, "App ID");
                return new String(Base64.decodeBase64((String)parsedResponse.configFileContents), StandardCharsets.UTF_8);
            }
        };
    }

    @Override
    public List<ShaCertificate> getShaCertificates(String appId) throws FirebaseProjectManagementException {
        return this.getShaCertificatesOp(appId).call();
    }

    @Override
    public ApiFuture<List<ShaCertificate>> getShaCertificatesAsync(String appId) {
        return this.getShaCertificatesOp(appId).callAsync(this.app);
    }

    private CallableOperation<List<ShaCertificate>, FirebaseProjectManagementException> getShaCertificatesOp(final String appId) {
        return new CallableOperation<List<ShaCertificate>, FirebaseProjectManagementException>(){

            @Override
            protected List<ShaCertificate> execute() throws FirebaseProjectManagementException {
                String url = String.format("%s/v1beta1/projects/-/androidApps/%s/sha", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, appId);
                ListShaCertificateResponse parsedResponse = new ListShaCertificateResponse();
                FirebaseProjectManagementServiceImpl.this.httpHelper.makeGetRequest(url, parsedResponse, appId, "App ID");
                ArrayList<ShaCertificate> certificates = new ArrayList<ShaCertificate>();
                if (parsedResponse.certificates == null) {
                    return certificates;
                }
                for (ShaCertificateResponse certificate : parsedResponse.certificates) {
                    certificates.add(ShaCertificate.create(certificate.name, certificate.shaHash));
                }
                return certificates;
            }
        };
    }

    @Override
    public ShaCertificate createShaCertificate(String appId, ShaCertificate certificateToAdd) throws FirebaseProjectManagementException {
        return this.createShaCertificateOp(appId, certificateToAdd).call();
    }

    @Override
    public ApiFuture<ShaCertificate> createShaCertificateAsync(String appId, ShaCertificate certificateToAdd) {
        return this.createShaCertificateOp(appId, certificateToAdd).callAsync(this.app);
    }

    private CallableOperation<ShaCertificate, FirebaseProjectManagementException> createShaCertificateOp(final String appId, final ShaCertificate certificateToAdd) {
        return new CallableOperation<ShaCertificate, FirebaseProjectManagementException>(){

            @Override
            protected ShaCertificate execute() throws FirebaseProjectManagementException {
                String url = String.format("%s/v1beta1/projects/-/androidApps/%s/sha", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, appId);
                ShaCertificateResponse parsedResponse = new ShaCertificateResponse();
                ImmutableMap payload = ImmutableMap.builder().put((Object)"sha_hash", (Object)certificateToAdd.getShaHash()).put((Object)"cert_type", (Object)certificateToAdd.getCertType().toString()).build();
                FirebaseProjectManagementServiceImpl.this.httpHelper.makePostRequest(url, payload, parsedResponse, appId, "App ID");
                return ShaCertificate.create(parsedResponse.name, parsedResponse.shaHash);
            }
        };
    }

    @Override
    public void deleteShaCertificate(String resourceName) throws FirebaseProjectManagementException {
        this.deleteShaCertificateOp(resourceName).call();
    }

    @Override
    public ApiFuture<Void> deleteShaCertificateAsync(String resourceName) {
        return this.deleteShaCertificateOp(resourceName).callAsync(this.app);
    }

    private CallableOperation<Void, FirebaseProjectManagementException> deleteShaCertificateOp(final String resourceName) {
        return new CallableOperation<Void, FirebaseProjectManagementException>(){

            @Override
            protected Void execute() throws FirebaseProjectManagementException {
                String url = String.format("%s/v1beta1/%s", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, resourceName);
                EmptyResponse parsedResponse = new EmptyResponse();
                FirebaseProjectManagementServiceImpl.this.httpHelper.makeDeleteRequest(url, parsedResponse, resourceName, "SHA name");
                return null;
            }
        };
    }

    private void sleepOrThrow(String projectId, long delayMillis) throws FirebaseProjectManagementException {
        try {
            this.sleeper.sleep(delayMillis);
        }
        catch (InterruptedException e) {
            String message = this.buildMessage(projectId, "Project ID", "Unable to create App: exponential backoff interrupted.");
            throw new FirebaseProjectManagementException(ErrorCode.ABORTED, message, null);
        }
    }

    private String buildMessage(String resourceId, String resourceIdName, String description) {
        return String.format("%s \"%s\": %s", resourceIdName, resourceId, description);
    }

    private class CreateIosAppFromAppIdFunction
    implements CreateAppFromAppIdFunction<IosApp> {
        private CreateIosAppFromAppIdFunction() {
        }

        public IosApp apply(String appId) {
            return new IosApp(appId, FirebaseProjectManagementServiceImpl.this);
        }
    }

    private class CreateAndroidAppFromAppIdFunction
    implements CreateAppFromAppIdFunction<AndroidApp> {
        private CreateAndroidAppFromAppIdFunction() {
        }

        public AndroidApp apply(String appId) {
            return new AndroidApp(appId, FirebaseProjectManagementServiceImpl.this);
        }
    }

    private static interface CreateAppFromAppIdFunction<T>
    extends ApiFunction<String, T> {
    }

    private static class FirebaseAppScheduler
    implements Scheduler {
        private final FirebaseApp app;

        FirebaseAppScheduler(FirebaseApp app) {
            this.app = (FirebaseApp)Preconditions.checkNotNull((Object)app);
        }

        @Override
        public void schedule(Runnable runnable, long delayMillis) {
            ImplFirebaseTrampolines.schedule(this.app, runnable, delayMillis);
        }
    }

    public static class ShaCertificateResponse {
        @Key(value="name")
        private String name;
        @Key(value="shaHash")
        private String shaHash;
        @Key(value="certType")
        private String certType;
    }

    private static class ListShaCertificateResponse {
        @Key(value="certificates")
        private List<ShaCertificateResponse> certificates;

        private ListShaCertificateResponse() {
        }
    }

    private static class AppConfigResponse {
        @Key(value="configFilename")
        String configFilename;
        @Key(value="configFileContents")
        String configFileContents;

        private AppConfigResponse() {
        }
    }

    private static class EmptyResponse {
        private EmptyResponse() {
        }
    }

    private static class OperationResponse {
        @Key(value="name")
        private String name;
        @Key(value="metadata")
        private String metadata;
        @Key(value="done")
        private boolean done;
        @Key(value="error")
        private StatusResponse error;
        @Key(value="response")
        private AppResponse response;

        private OperationResponse() {
        }
    }

    public static class StatusResponse {
        @Key(value="code")
        private int code;
        @Key(value="message")
        private String message;
    }

    private static class IosAppResponse
    extends AppResponse {
        @Key(value="bundleId")
        private String bundleId;

        private IosAppResponse() {
        }
    }

    private static class AndroidAppResponse
    extends AppResponse {
        @Key(value="packageName")
        private String packageName;

        private AndroidAppResponse() {
        }
    }

    public static class AppResponse {
        @Key(value="name")
        protected String name;
        @Key(value="appId")
        protected String appId;
        @Key(value="displayName")
        protected String displayName;
        @Key(value="projectId")
        protected String projectId;
    }

    private class WaitOperationRunnable
    implements Runnable {
        private final int numberOfPreviousPolls;
        private final String operationName;
        private final String projectId;
        private final SettableApiFuture<String> settableFuture;

        private WaitOperationRunnable(int numberOfPreviousPolls, String operationName, String projectId, SettableApiFuture<String> settableFuture) {
            this.numberOfPreviousPolls = numberOfPreviousPolls;
            this.operationName = operationName;
            this.projectId = projectId;
            this.settableFuture = settableFuture;
        }

        @Override
        public void run() {
            IncomingHttpResponse httpResponse;
            String url = String.format("%s/v1/%s", FirebaseProjectManagementServiceImpl.FIREBASE_PROJECT_MANAGEMENT_URL, this.operationName);
            OperationResponse operationResponseInstance = new OperationResponse();
            try {
                httpResponse = FirebaseProjectManagementServiceImpl.this.httpHelper.makeGetRequest(url, operationResponseInstance, this.projectId, "Project ID");
            }
            catch (FirebaseProjectManagementException e) {
                this.settableFuture.setException((Throwable)e);
                return;
            }
            if (!operationResponseInstance.done) {
                if (this.numberOfPreviousPolls + 1 >= 7) {
                    String message = FirebaseProjectManagementServiceImpl.this.buildMessage(this.projectId, "Project ID", "Unable to create App: deadline exceeded.");
                    FirebaseProjectManagementException exception = new FirebaseProjectManagementException(ErrorCode.DEADLINE_EXCEEDED, message, httpResponse);
                    this.settableFuture.setException((Throwable)exception);
                } else {
                    long delayMillis = (long)(500.0 * Math.pow(1.5, this.numberOfPreviousPolls + 1));
                    FirebaseProjectManagementServiceImpl.this.scheduler.schedule(new WaitOperationRunnable(this.numberOfPreviousPolls + 1, this.operationName, this.projectId, this.settableFuture), delayMillis);
                }
                return;
            }
            if (operationResponseInstance.response == null || Strings.isNullOrEmpty((String)((OperationResponse)operationResponseInstance).response.appId)) {
                String message = FirebaseProjectManagementServiceImpl.this.buildMessage(this.projectId, "Project ID", "Unable to create App: internal server error.");
                FirebaseProjectManagementException exception = new FirebaseProjectManagementException(ErrorCode.INTERNAL, message, httpResponse);
                this.settableFuture.setException((Throwable)exception);
            } else {
                this.settableFuture.set((Object)((OperationResponse)operationResponseInstance).response.appId);
            }
        }
    }

    private class WaitOperationFunction
    implements ApiAsyncFunction<String, String> {
        private final String projectId;

        private WaitOperationFunction(String projectId) {
            this.projectId = projectId;
        }

        public ApiFuture<String> apply(String operationName) {
            SettableApiFuture settableFuture = SettableApiFuture.create();
            FirebaseProjectManagementServiceImpl.this.scheduler.schedule(new WaitOperationRunnable(0, operationName, this.projectId, settableFuture), 500L);
            return settableFuture;
        }
    }

    private static class ListAppsResponse {
        @Key(value="apps")
        private List<AppResponse> apps;
        @Key(value="nextPageToken")
        private String nextPageToken;

        private ListAppsResponse() {
        }
    }
}

