/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.ErrorCode;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthErrorCode;
import com.google.firebase.auth.DeleteUsersResult;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.ImportUserRecord;
import com.google.firebase.auth.OidcProviderConfig;
import com.google.firebase.auth.SamlProviderConfig;
import com.google.firebase.auth.SessionCookieOptions;
import com.google.firebase.auth.UserIdentifier;
import com.google.firebase.auth.UserImportOptions;
import com.google.firebase.auth.UserImportResult;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.AuthHttpClient;
import com.google.firebase.auth.internal.BatchDeleteResponse;
import com.google.firebase.auth.internal.DownloadAccountResponse;
import com.google.firebase.auth.internal.GetAccountInfoRequest;
import com.google.firebase.auth.internal.GetAccountInfoResponse;
import com.google.firebase.auth.internal.ListOidcProviderConfigsResponse;
import com.google.firebase.auth.internal.ListSamlProviderConfigsResponse;
import com.google.firebase.auth.internal.UploadAccountResponse;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.HttpRequestInfo;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class FirebaseUserManager {
    static final int MAX_LIST_PROVIDER_CONFIGS_RESULTS = 100;
    static final int MAX_GET_ACCOUNTS_BATCH_SIZE = 100;
    static final int MAX_DELETE_ACCOUNTS_BATCH_SIZE = 1000;
    static final int MAX_LIST_USERS_RESULTS = 1000;
    static final int MAX_IMPORT_USERS = 1000;
    static final List<String> RESERVED_CLAIMS = ImmutableList.of((Object)"amr", (Object)"at_hash", (Object)"aud", (Object)"auth_time", (Object)"azp", (Object)"cnf", (Object)"c_hash", (Object)"exp", (Object)"iat", (Object)"iss", (Object)"jti", (Object)"nbf", (Object[])new String[]{"nonce", "sub", "firebase"});
    private static final String ID_TOOLKIT_URL = "https://identitytoolkit.googleapis.com/%s/projects/%s";
    private final String userMgtBaseUrl;
    private final String idpConfigMgtBaseUrl;
    private final JsonFactory jsonFactory;
    private final AuthHttpClient httpClient;

    private FirebaseUserManager(Builder builder) {
        String projectId = builder.projectId;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required to access the auth service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)builder.jsonFactory, (Object)"JsonFactory must not be null");
        String idToolkitUrlV1 = String.format(ID_TOOLKIT_URL, "v1", projectId);
        String idToolkitUrlV2 = String.format(ID_TOOLKIT_URL, "v2", projectId);
        String tenantId = builder.tenantId;
        if (tenantId == null) {
            this.userMgtBaseUrl = idToolkitUrlV1;
            this.idpConfigMgtBaseUrl = idToolkitUrlV2;
        } else {
            Preconditions.checkArgument((!tenantId.isEmpty() ? 1 : 0) != 0, (Object)"Tenant ID must not be empty.");
            this.userMgtBaseUrl = idToolkitUrlV1 + "/tenants/" + tenantId;
            this.idpConfigMgtBaseUrl = idToolkitUrlV2 + "/tenants/" + tenantId;
        }
        this.httpClient = new AuthHttpClient(this.jsonFactory, builder.requestFactory);
    }

    @VisibleForTesting
    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.httpClient.setInterceptor(interceptor);
    }

    UserRecord getUserById(String uid) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"localId", (Object)ImmutableList.of((Object)uid));
        return this.lookupUserAccount((Map<String, Object>)payload, "user ID: " + uid);
    }

    UserRecord getUserByEmail(String email) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"email", (Object)ImmutableList.of((Object)email));
        return this.lookupUserAccount((Map<String, Object>)payload, "email: " + email);
    }

    UserRecord getUserByPhoneNumber(String phoneNumber) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"phoneNumber", (Object)ImmutableList.of((Object)phoneNumber));
        return this.lookupUserAccount((Map<String, Object>)payload, "phone number: " + phoneNumber);
    }

    Set<UserRecord> getAccountInfo(@NonNull Collection<UserIdentifier> identifiers) throws FirebaseAuthException {
        if (identifiers.isEmpty()) {
            return new HashSet<UserRecord>();
        }
        GetAccountInfoRequest payload = new GetAccountInfoRequest();
        for (UserIdentifier id : identifiers) {
            id.populate(payload);
        }
        GetAccountInfoResponse response = this.post("/accounts:lookup", payload, GetAccountInfoResponse.class);
        HashSet<UserRecord> results = new HashSet<UserRecord>();
        if (response.getUsers() != null) {
            for (GetAccountInfoResponse.User user : response.getUsers()) {
                results.add(new UserRecord(user, this.jsonFactory));
            }
        }
        return results;
    }

    String createUser(UserRecord.CreateRequest request) throws FirebaseAuthException {
        GenericJson response = this.post("/accounts", request.getProperties(), GenericJson.class);
        return (String)response.get((Object)"localId");
    }

    void updateUser(UserRecord.UpdateRequest request, JsonFactory jsonFactory) throws FirebaseAuthException {
        this.post("/accounts:update", request.getProperties(jsonFactory), GenericJson.class);
    }

    void deleteUser(String uid) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"localId", (Object)uid);
        this.post("/accounts:delete", payload, GenericJson.class);
    }

    DeleteUsersResult deleteUsers(@NonNull List<String> uids) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"localIds", uids, (Object)"force", (Object)true);
        BatchDeleteResponse response = this.post("/accounts:batchDelete", payload, BatchDeleteResponse.class);
        return new DeleteUsersResult(uids.size(), response);
    }

    DownloadAccountResponse listUsers(int maxResults, String pageToken) throws FirebaseAuthException {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"maxResults", (Object)maxResults);
        if (pageToken != null) {
            Preconditions.checkArgument((!pageToken.equals("") ? 1 : 0) != 0, (Object)"invalid end of list page token");
            builder.put((Object)"nextPageToken", (Object)pageToken);
        }
        String url = this.userMgtBaseUrl + "/accounts:batchGet";
        HttpRequestInfo requestInfo = HttpRequestInfo.buildGetRequest(url).addAllParameters((Map<String, Object>)builder.build());
        return this.httpClient.sendRequest(requestInfo, DownloadAccountResponse.class);
    }

    UserImportResult importUsers(UserImportRequest request) throws FirebaseAuthException {
        Preconditions.checkNotNull((Object)((Object)request));
        UploadAccountResponse response = this.post("/accounts:batchCreate", (Object)request, UploadAccountResponse.class);
        return new UserImportResult(request.getUsersCount(), response);
    }

    String createSessionCookie(String idToken, SessionCookieOptions options) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"idToken", (Object)idToken, (Object)"validDuration", (Object)options.getExpiresInSeconds());
        GenericJson response = this.post(":createSessionCookie", payload, GenericJson.class);
        return (String)response.get((Object)"sessionCookie");
    }

    String getEmailActionLink(EmailLinkType type, String email, @Nullable ActionCodeSettings settings) throws FirebaseAuthException {
        ImmutableMap.Builder payload = ImmutableMap.builder().put((Object)"requestType", (Object)type.name()).put((Object)"email", (Object)email).put((Object)"returnOobLink", (Object)true);
        if (settings != null) {
            payload.putAll(settings.getProperties());
        }
        GenericJson response = this.post("/accounts:sendOobCode", payload.build(), GenericJson.class);
        return (String)response.get((Object)"oobLink");
    }

    private UserRecord lookupUserAccount(Map<String, Object> payload, String identifier) throws FirebaseAuthException {
        HttpRequestInfo requestInfo = HttpRequestInfo.buildJsonPostRequest(this.userMgtBaseUrl + "/accounts:lookup", payload);
        IncomingHttpResponse response = this.httpClient.sendRequest(requestInfo);
        GetAccountInfoResponse parsed = this.httpClient.parse(response, GetAccountInfoResponse.class);
        if (parsed.getUsers() == null || parsed.getUsers().isEmpty()) {
            throw new FirebaseAuthException(ErrorCode.NOT_FOUND, "No user record found for the provided " + identifier, null, response, AuthErrorCode.USER_NOT_FOUND);
        }
        return new UserRecord(parsed.getUsers().get(0), this.jsonFactory);
    }

    OidcProviderConfig createOidcProviderConfig(OidcProviderConfig.CreateRequest request) throws FirebaseAuthException {
        String url = this.idpConfigMgtBaseUrl + "/oauthIdpConfigs";
        HttpRequestInfo requestInfo = HttpRequestInfo.buildJsonPostRequest(url, request.getProperties()).addParameter("oauthIdpConfigId", request.getProviderId());
        return this.httpClient.sendRequest(requestInfo, OidcProviderConfig.class);
    }

    SamlProviderConfig createSamlProviderConfig(SamlProviderConfig.CreateRequest request) throws FirebaseAuthException {
        String url = this.idpConfigMgtBaseUrl + "/inboundSamlConfigs";
        HttpRequestInfo requestInfo = HttpRequestInfo.buildJsonPostRequest(url, request.getProperties()).addParameter("inboundSamlConfigId", request.getProviderId());
        return this.httpClient.sendRequest(requestInfo, SamlProviderConfig.class);
    }

    OidcProviderConfig updateOidcProviderConfig(OidcProviderConfig.UpdateRequest request) throws FirebaseAuthException {
        Map<String, Object> properties = request.getProperties();
        String url = this.idpConfigMgtBaseUrl + FirebaseUserManager.getOidcUrlSuffix(request.getProviderId());
        HttpRequestInfo requestInfo = HttpRequestInfo.buildJsonPatchRequest(url, properties).addParameter("updateMask", Joiner.on((String)",").join(AuthHttpClient.generateMask(properties)));
        return this.httpClient.sendRequest(requestInfo, OidcProviderConfig.class);
    }

    SamlProviderConfig updateSamlProviderConfig(SamlProviderConfig.UpdateRequest request) throws FirebaseAuthException {
        Map<String, Object> properties = request.getProperties();
        String url = this.idpConfigMgtBaseUrl + FirebaseUserManager.getSamlUrlSuffix(request.getProviderId());
        HttpRequestInfo requestInfo = HttpRequestInfo.buildJsonPatchRequest(url, properties).addParameter("updateMask", Joiner.on((String)",").join(AuthHttpClient.generateMask(properties)));
        return this.httpClient.sendRequest(requestInfo, SamlProviderConfig.class);
    }

    OidcProviderConfig getOidcProviderConfig(String providerId) throws FirebaseAuthException {
        String url = this.idpConfigMgtBaseUrl + FirebaseUserManager.getOidcUrlSuffix(providerId);
        return this.httpClient.sendRequest(HttpRequestInfo.buildGetRequest(url), OidcProviderConfig.class);
    }

    SamlProviderConfig getSamlProviderConfig(String providerId) throws FirebaseAuthException {
        String url = this.idpConfigMgtBaseUrl + FirebaseUserManager.getSamlUrlSuffix(providerId);
        return this.httpClient.sendRequest(HttpRequestInfo.buildGetRequest(url), SamlProviderConfig.class);
    }

    ListOidcProviderConfigsResponse listOidcProviderConfigs(int maxResults, String pageToken) throws FirebaseAuthException {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"pageSize", (Object)maxResults);
        if (pageToken != null) {
            Preconditions.checkArgument((!pageToken.equals("") ? 1 : 0) != 0, (Object)"Invalid end of list page token.");
            builder.put((Object)"nextPageToken", (Object)pageToken);
        }
        String url = this.idpConfigMgtBaseUrl + "/oauthIdpConfigs";
        HttpRequestInfo requestInfo = HttpRequestInfo.buildGetRequest(url).addAllParameters((Map<String, Object>)builder.build());
        return this.httpClient.sendRequest(requestInfo, ListOidcProviderConfigsResponse.class);
    }

    ListSamlProviderConfigsResponse listSamlProviderConfigs(int maxResults, String pageToken) throws FirebaseAuthException {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"pageSize", (Object)maxResults);
        if (pageToken != null) {
            Preconditions.checkArgument((!pageToken.equals("") ? 1 : 0) != 0, (Object)"Invalid end of list page token.");
            builder.put((Object)"nextPageToken", (Object)pageToken);
        }
        String url = this.idpConfigMgtBaseUrl + "/inboundSamlConfigs";
        HttpRequestInfo requestInfo = HttpRequestInfo.buildGetRequest(url).addAllParameters((Map<String, Object>)builder.build());
        return this.httpClient.sendRequest(requestInfo, ListSamlProviderConfigsResponse.class);
    }

    void deleteOidcProviderConfig(String providerId) throws FirebaseAuthException {
        String url = this.idpConfigMgtBaseUrl + FirebaseUserManager.getOidcUrlSuffix(providerId);
        this.httpClient.sendRequest(HttpRequestInfo.buildDeleteRequest(url));
    }

    void deleteSamlProviderConfig(String providerId) throws FirebaseAuthException {
        String url = this.idpConfigMgtBaseUrl + FirebaseUserManager.getSamlUrlSuffix(providerId);
        this.httpClient.sendRequest(HttpRequestInfo.buildDeleteRequest(url));
    }

    private static String getOidcUrlSuffix(String providerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"Provider ID must not be null or empty.");
        return "/oauthIdpConfigs/" + providerId;
    }

    private static String getSamlUrlSuffix(String providerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"Provider ID must not be null or empty.");
        return "/inboundSamlConfigs/" + providerId;
    }

    private <T> T post(String path, Object content, Class<T> clazz) throws FirebaseAuthException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"path must not be null or empty");
        Preconditions.checkNotNull((Object)content, (Object)"content must not be null for POST requests");
        String url = this.userMgtBaseUrl + path;
        return this.httpClient.sendRequest(HttpRequestInfo.buildJsonPostRequest(url, content), clazz);
    }

    static FirebaseUserManager createUserManager(FirebaseApp app, String tenantId) {
        return FirebaseUserManager.builder().setProjectId(ImplFirebaseTrampolines.getProjectId(app)).setTenantId(tenantId).setHttpRequestFactory(ApiClientUtils.newAuthorizedRequestFactory(app)).setJsonFactory(app.getOptions().getJsonFactory()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private String projectId;
        private String tenantId;
        private HttpRequestFactory requestFactory;
        private JsonFactory jsonFactory;

        private Builder() {
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        Builder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        Builder setHttpRequestFactory(HttpRequestFactory requestFactory) {
            this.requestFactory = requestFactory;
            return this;
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        FirebaseUserManager build() {
            return new FirebaseUserManager(this);
        }
    }

    static enum EmailLinkType {
        VERIFY_EMAIL,
        EMAIL_SIGNIN,
        PASSWORD_RESET;

    }

    static class UserImportRequest
    extends GenericJson {
        @Key(value="users")
        private final List<Map<String, Object>> users;

        UserImportRequest(List<ImportUserRecord> users, UserImportOptions options, JsonFactory jsonFactory) {
            Preconditions.checkArgument((users != null && !users.isEmpty() ? 1 : 0) != 0, (Object)"users must not be null or empty");
            Preconditions.checkArgument((users.size() <= 1000 ? 1 : 0) != 0, (String)"users list must not contain more than %s items", (int)1000);
            boolean hasPassword = false;
            ImmutableList.Builder usersBuilder = ImmutableList.builder();
            for (ImportUserRecord user : users) {
                if (user.hasPassword()) {
                    hasPassword = true;
                }
                usersBuilder.add(user.getProperties(jsonFactory));
            }
            this.users = usersBuilder.build();
            if (hasPassword) {
                Preconditions.checkArgument((options != null && options.getHash() != null ? 1 : 0) != 0, (Object)"UserImportHash option is required when at least one user has a password. Provide a UserImportHash via UserImportOptions.withHash().");
                this.putAll(options.getProperties());
            }
        }

        int getUsersCount() {
            return this.users.size();
        }
    }
}

