/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.FirebaseMessagingClient;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.InstanceIdClient;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.MulticastMessage;
import com.google.firebase.messaging.TopicManagementResponse;
import java.util.List;

public class FirebaseMessaging {
    static final String INTERNAL_ERROR = "internal-error";
    static final String UNKNOWN_ERROR = "unknown-error";
    private final FirebaseApp app;
    private final FirebaseMessagingClient messagingClient;
    private final InstanceIdClient instanceIdClient;
    private static final String SERVICE_ID = FirebaseMessaging.class.getName();

    private FirebaseMessaging(FirebaseApp app) {
        this(app, (HttpResponseInterceptor)null);
    }

    @VisibleForTesting
    FirebaseMessaging(FirebaseApp app, @Nullable HttpResponseInterceptor responseInterceptor) {
        this.app = (FirebaseApp)Preconditions.checkNotNull((Object)app, (Object)"app must not be null");
        this.messagingClient = new FirebaseMessagingClient(app, responseInterceptor);
        this.instanceIdClient = new InstanceIdClient(app, responseInterceptor);
    }

    public static FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseMessaging getInstance(FirebaseApp app) {
        FirebaseMessagingService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseMessagingService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseMessagingService(app));
        }
        return (FirebaseMessaging)service.getInstance();
    }

    public String send(@NonNull Message message) throws FirebaseMessagingException {
        return this.send(message, false);
    }

    public String send(@NonNull Message message, boolean dryRun) throws FirebaseMessagingException {
        return this.sendOp(message, dryRun).call();
    }

    public ApiFuture<String> sendAsync(@NonNull Message message) {
        return this.sendAsync(message, false);
    }

    public ApiFuture<String> sendAsync(@NonNull Message message, boolean dryRun) {
        return this.sendOp(message, dryRun).callAsync(this.app);
    }

    private CallableOperation<String, FirebaseMessagingException> sendOp(final Message message, final boolean dryRun) {
        Preconditions.checkNotNull((Object)message, (Object)"message must not be null");
        return new CallableOperation<String, FirebaseMessagingException>(){

            @Override
            protected String execute() throws FirebaseMessagingException {
                return FirebaseMessaging.this.messagingClient.send(message, dryRun);
            }
        };
    }

    public BatchResponse sendAll(@NonNull List<Message> messages) throws FirebaseMessagingException {
        return this.sendAll(messages, false);
    }

    public BatchResponse sendAll(@NonNull List<Message> messages, boolean dryRun) throws FirebaseMessagingException {
        return this.sendAllOp(messages, dryRun).call();
    }

    public ApiFuture<BatchResponse> sendAllAsync(@NonNull List<Message> messages) {
        return this.sendAllAsync(messages, false);
    }

    public ApiFuture<BatchResponse> sendAllAsync(@NonNull List<Message> messages, boolean dryRun) {
        return this.sendAllOp(messages, dryRun).callAsync(this.app);
    }

    public BatchResponse sendMulticast(@NonNull MulticastMessage message) throws FirebaseMessagingException {
        return this.sendMulticast(message, false);
    }

    public BatchResponse sendMulticast(@NonNull MulticastMessage message, boolean dryRun) throws FirebaseMessagingException {
        Preconditions.checkNotNull((Object)message, (Object)"multicast message must not be null");
        return this.sendAll(message.getMessageList(), dryRun);
    }

    public ApiFuture<BatchResponse> sendMulticastAsync(@NonNull MulticastMessage message) {
        return this.sendMulticastAsync(message, false);
    }

    public ApiFuture<BatchResponse> sendMulticastAsync(@NonNull MulticastMessage message, boolean dryRun) {
        Preconditions.checkNotNull((Object)message, (Object)"multicast message must not be null");
        return this.sendAllAsync(message.getMessageList(), dryRun);
    }

    private CallableOperation<BatchResponse, FirebaseMessagingException> sendAllOp(final List<Message> messages, final boolean dryRun) {
        ImmutableList immutableMessages = ImmutableList.copyOf(messages);
        Preconditions.checkArgument((!immutableMessages.isEmpty() ? 1 : 0) != 0, (Object)"messages list must not be empty");
        Preconditions.checkArgument((immutableMessages.size() <= 100 ? 1 : 0) != 0, (Object)"messages list must not contain more than 100 elements");
        return new CallableOperation<BatchResponse, FirebaseMessagingException>(){

            @Override
            protected BatchResponse execute() throws FirebaseMessagingException {
                return FirebaseMessaging.this.messagingClient.sendAll(messages, dryRun);
            }
        };
    }

    public TopicManagementResponse subscribeToTopic(@NonNull List<String> registrationTokens, @NonNull String topic) throws FirebaseMessagingException {
        return this.subscribeOp(registrationTokens, topic).call();
    }

    public ApiFuture<TopicManagementResponse> subscribeToTopicAsync(@NonNull List<String> registrationTokens, @NonNull String topic) {
        return this.subscribeOp(registrationTokens, topic).callAsync(this.app);
    }

    private CallableOperation<TopicManagementResponse, FirebaseMessagingException> subscribeOp(final List<String> registrationTokens, final String topic) {
        FirebaseMessaging.checkRegistrationTokens(registrationTokens);
        FirebaseMessaging.checkTopic(topic);
        return new CallableOperation<TopicManagementResponse, FirebaseMessagingException>(){

            @Override
            protected TopicManagementResponse execute() throws FirebaseMessagingException {
                return FirebaseMessaging.this.instanceIdClient.subscribeToTopic(topic, registrationTokens);
            }
        };
    }

    public TopicManagementResponse unsubscribeFromTopic(@NonNull List<String> registrationTokens, @NonNull String topic) throws FirebaseMessagingException {
        return this.unsubscribeOp(registrationTokens, topic).call();
    }

    public ApiFuture<TopicManagementResponse> unsubscribeFromTopicAsync(@NonNull List<String> registrationTokens, @NonNull String topic) {
        return this.unsubscribeOp(registrationTokens, topic).callAsync(this.app);
    }

    private CallableOperation<TopicManagementResponse, FirebaseMessagingException> unsubscribeOp(final List<String> registrationTokens, final String topic) {
        FirebaseMessaging.checkRegistrationTokens(registrationTokens);
        FirebaseMessaging.checkTopic(topic);
        return new CallableOperation<TopicManagementResponse, FirebaseMessagingException>(){

            @Override
            protected TopicManagementResponse execute() throws FirebaseMessagingException {
                return FirebaseMessaging.this.instanceIdClient.unsubscribeFromTopic(topic, registrationTokens);
            }
        };
    }

    private static void checkRegistrationTokens(List<String> registrationTokens) {
        Preconditions.checkArgument((registrationTokens != null && !registrationTokens.isEmpty() ? 1 : 0) != 0, (Object)"registrationTokens list must not be null or empty");
        Preconditions.checkArgument((registrationTokens.size() <= 1000 ? 1 : 0) != 0, (Object)"registrationTokens list must not contain more than 1000 elements");
        for (String token : registrationTokens) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0, (Object)"registration tokens list must not contain null or empty strings");
        }
    }

    private static void checkTopic(String topic) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)topic) ? 1 : 0) != 0, (Object)"topic must not be null or empty");
        Preconditions.checkArgument((boolean)topic.matches("^(/topics/)?(private/)?[a-zA-Z0-9-_.~%]+$"), (Object)"invalid topic name");
    }

    private static class FirebaseMessagingService
    extends FirebaseService<FirebaseMessaging> {
        FirebaseMessagingService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseMessaging(app));
        }

        @Override
        public void destroy() {
        }
    }
}

