/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.ApsAlert;
import java.util.HashMap;
import java.util.Map;

public class Aps {
    private final Map<String, Object> fields;

    private Aps(Builder builder) {
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)builder.alertString) || builder.alert == null ? 1 : 0) != 0, (Object)"Multiple alert specifications (string and ApsAlert) found.");
        ImmutableMap.Builder fields = ImmutableMap.builder();
        if (builder.alert != null) {
            fields.put((Object)"alert", (Object)builder.alert);
        } else if (builder.alertString != null) {
            fields.put((Object)"alert", (Object)builder.alertString);
        }
        if (builder.badge != null) {
            fields.put((Object)"badge", (Object)builder.badge);
        }
        if (builder.sound != null) {
            fields.put((Object)"sound", (Object)builder.sound);
        }
        if (builder.contentAvailable) {
            fields.put((Object)"content-available", (Object)1);
        }
        if (builder.mutableContent) {
            fields.put((Object)"mutable-content", (Object)1);
        }
        if (builder.category != null) {
            fields.put((Object)"category", (Object)builder.category);
        }
        if (builder.threadId != null) {
            fields.put((Object)"thread-id", (Object)builder.threadId);
        }
        fields.putAll(builder.customData);
        this.fields = fields.build();
    }

    Map<String, Object> getFields() {
        return this.fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String alertString;
        private ApsAlert alert;
        private Integer badge;
        private String sound;
        private boolean contentAvailable;
        private boolean mutableContent;
        private String category;
        private String threadId;
        private final Map<String, Object> customData = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alertString = alert;
            return this;
        }

        public Builder setAlert(ApsAlert alert) {
            this.alert = alert;
            return this;
        }

        public Builder setBadge(int badge) {
            this.badge = badge;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setContentAvailable(boolean contentAvailable) {
            this.contentAvailable = contentAvailable;
            return this;
        }

        public Builder setMutableContent(boolean mutableContent) {
            this.mutableContent = mutableContent;
            return this;
        }

        public Builder putCustomData(@NonNull String key, @NonNull Object value) {
            this.customData.put(key, value);
            return this;
        }

        public Builder putAllCustomData(@NonNull Map<String, Object> fields) {
            this.customData.putAll(fields);
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setThreadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public Aps build() {
            return new Aps(this);
        }
    }
}

