/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.ImportUserRecord;
import com.google.firebase.auth.SessionCookieOptions;
import com.google.firebase.auth.UserImportOptions;
import com.google.firebase.auth.UserImportResult;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.DownloadAccountResponse;
import com.google.firebase.auth.internal.GetAccountInfoResponse;
import com.google.firebase.auth.internal.HttpErrorResponse;
import com.google.firebase.auth.internal.UploadAccountResponse;
import com.google.firebase.internal.FirebaseRequestInitializer;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.SdkUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class FirebaseUserManager {
    static final String USER_NOT_FOUND_ERROR = "user-not-found";
    static final String INTERNAL_ERROR = "internal-error";
    static final String ID_TOKEN_REVOKED_ERROR = "id-token-revoked";
    static final String SESSION_COOKIE_REVOKED_ERROR = "session-cookie-revoked";
    private static final Map<String, String> ERROR_CODES = ImmutableMap.builder().put((Object)"CLAIMS_TOO_LARGE", (Object)"claims-too-large").put((Object)"CONFIGURATION_NOT_FOUND", (Object)"project-not-found").put((Object)"INSUFFICIENT_PERMISSION", (Object)"insufficient-permission").put((Object)"DUPLICATE_EMAIL", (Object)"email-already-exists").put((Object)"DUPLICATE_LOCAL_ID", (Object)"uid-already-exists").put((Object)"EMAIL_EXISTS", (Object)"email-already-exists").put((Object)"INVALID_CLAIMS", (Object)"invalid-claims").put((Object)"INVALID_EMAIL", (Object)"invalid-email").put((Object)"INVALID_PAGE_SELECTION", (Object)"invalid-page-token").put((Object)"INVALID_PHONE_NUMBER", (Object)"invalid-phone-number").put((Object)"PHONE_NUMBER_EXISTS", (Object)"phone-number-already-exists").put((Object)"PROJECT_NOT_FOUND", (Object)"project-not-found").put((Object)"USER_NOT_FOUND", (Object)"user-not-found").put((Object)"WEAK_PASSWORD", (Object)"invalid-password").build();
    static final int MAX_LIST_USERS_RESULTS = 1000;
    static final int MAX_IMPORT_USERS = 1000;
    static final List<String> RESERVED_CLAIMS = ImmutableList.of((Object)"amr", (Object)"at_hash", (Object)"aud", (Object)"auth_time", (Object)"azp", (Object)"cnf", (Object)"c_hash", (Object)"exp", (Object)"iat", (Object)"iss", (Object)"jti", (Object)"nbf", (Object[])new String[]{"nonce", "sub", "firebase"});
    private static final String ID_TOOLKIT_URL = "https://www.googleapis.com/identitytoolkit/v3/relyingparty/";
    private static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    private final JsonFactory jsonFactory;
    private final HttpRequestFactory requestFactory;
    private final String clientVersion = "Java/Admin/" + SdkUtils.getVersion();
    private HttpResponseInterceptor interceptor;

    FirebaseUserManager(@NonNull FirebaseApp app) {
        Preconditions.checkNotNull((Object)app, (Object)"FirebaseApp must not be null");
        this.jsonFactory = app.getOptions().getJsonFactory();
        HttpTransport transport = app.getOptions().getHttpTransport();
        this.requestFactory = transport.createRequestFactory((HttpRequestInitializer)new FirebaseRequestInitializer(app));
    }

    @VisibleForTesting
    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    UserRecord getUserById(String uid) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"localId", (Object)ImmutableList.of((Object)uid));
        GetAccountInfoResponse response = this.post("getAccountInfo", payload, GetAccountInfoResponse.class);
        if (response == null || response.getUsers() == null || response.getUsers().isEmpty()) {
            throw new FirebaseAuthException(USER_NOT_FOUND_ERROR, "No user record found for the provided user ID: " + uid);
        }
        return new UserRecord(response.getUsers().get(0), this.jsonFactory);
    }

    UserRecord getUserByEmail(String email) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"email", (Object)ImmutableList.of((Object)email));
        GetAccountInfoResponse response = this.post("getAccountInfo", payload, GetAccountInfoResponse.class);
        if (response == null || response.getUsers() == null || response.getUsers().isEmpty()) {
            throw new FirebaseAuthException(USER_NOT_FOUND_ERROR, "No user record found for the provided email: " + email);
        }
        return new UserRecord(response.getUsers().get(0), this.jsonFactory);
    }

    UserRecord getUserByPhoneNumber(String phoneNumber) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"phoneNumber", (Object)ImmutableList.of((Object)phoneNumber));
        GetAccountInfoResponse response = this.post("getAccountInfo", payload, GetAccountInfoResponse.class);
        if (response == null || response.getUsers() == null || response.getUsers().isEmpty()) {
            throw new FirebaseAuthException(USER_NOT_FOUND_ERROR, "No user record found for the provided phone number: " + phoneNumber);
        }
        return new UserRecord(response.getUsers().get(0), this.jsonFactory);
    }

    String createUser(UserRecord.CreateRequest request) throws FirebaseAuthException {
        String uid;
        GenericJson response = this.post("signupNewUser", request.getProperties(), GenericJson.class);
        if (response != null && !Strings.isNullOrEmpty((String)(uid = (String)response.get((Object)"localId")))) {
            return uid;
        }
        throw new FirebaseAuthException(INTERNAL_ERROR, "Failed to create new user");
    }

    void updateUser(UserRecord.UpdateRequest request, JsonFactory jsonFactory) throws FirebaseAuthException {
        GenericJson response = this.post("setAccountInfo", request.getProperties(jsonFactory), GenericJson.class);
        if (response == null || !request.getUid().equals(response.get((Object)"localId"))) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "Failed to update user: " + request.getUid());
        }
    }

    void deleteUser(String uid) throws FirebaseAuthException {
        ImmutableMap payload = ImmutableMap.of((Object)"localId", (Object)uid);
        GenericJson response = this.post("deleteAccount", payload, GenericJson.class);
        if (response == null || !response.containsKey((Object)"kind")) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "Failed to delete user: " + uid);
        }
    }

    DownloadAccountResponse listUsers(int maxResults, String pageToken) throws FirebaseAuthException {
        DownloadAccountResponse response;
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"maxResults", (Object)maxResults);
        if (pageToken != null) {
            Preconditions.checkArgument((!pageToken.equals("") ? 1 : 0) != 0, (Object)"invalid end of list page token");
            builder.put((Object)"nextPageToken", (Object)pageToken);
        }
        if ((response = this.post("downloadAccount", builder.build(), DownloadAccountResponse.class)) == null) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "Failed to retrieve users.");
        }
        return response;
    }

    UserImportResult importUsers(UserImportRequest request) throws FirebaseAuthException {
        Preconditions.checkNotNull((Object)((Object)request));
        UploadAccountResponse response = this.post("uploadAccount", (Object)request, UploadAccountResponse.class);
        if (response == null) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "Failed to import users.");
        }
        return new UserImportResult(request.getUsersCount(), response);
    }

    String createSessionCookie(String idToken, SessionCookieOptions options) throws FirebaseAuthException {
        String cookie;
        ImmutableMap payload = ImmutableMap.of((Object)"idToken", (Object)idToken, (Object)"validDuration", (Object)options.getExpiresInSeconds());
        GenericJson response = this.post("createSessionCookie", payload, GenericJson.class);
        if (response != null && !Strings.isNullOrEmpty((String)(cookie = (String)response.get((Object)"sessionCookie")))) {
            return cookie;
        }
        throw new FirebaseAuthException(INTERNAL_ERROR, "Failed to create session cookie");
    }

    private <T> T post(String path, Object content, Class<T> clazz) throws FirebaseAuthException {
        Object object;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"path must not be null or empty");
        Preconditions.checkNotNull((Object)content, (Object)"content must not be null");
        Preconditions.checkNotNull(clazz, (Object)"response class must not be null");
        GenericUrl url = new GenericUrl(ID_TOOLKIT_URL + path);
        HttpResponse response = null;
        try {
            HttpRequest request = this.requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(this.jsonFactory, content));
            request.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
            request.getHeaders().set(CLIENT_VERSION_HEADER, (Object)this.clientVersion);
            request.setResponseInterceptor(this.interceptor);
            response = request.execute();
            object = response.parseAs(clazz);
        }
        catch (HttpResponseException e) {
            this.handleHttpError(e);
            T t = null;
            return t;
        }
        catch (IOException e) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "Error while calling user management backend service", e);
        }
        finally {
            if (response != null) {
                try {
                    response.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)object;
    }

    private void handleHttpError(HttpResponseException e) throws FirebaseAuthException {
        try {
            HttpErrorResponse response = (HttpErrorResponse)this.jsonFactory.fromString(e.getContent(), HttpErrorResponse.class);
            String code = ERROR_CODES.get(response.getErrorCode());
            if (code != null) {
                throw new FirebaseAuthException(code, "User management service responded with an error", e);
            }
        }
        catch (IOException response) {
            // empty catch block
        }
        String msg = String.format("Unexpected HTTP response with status: %d; body: %s", e.getStatusCode(), e.getContent());
        throw new FirebaseAuthException(INTERNAL_ERROR, msg, e);
    }

    static class UserImportRequest
    extends GenericJson {
        @Key(value="users")
        private final List<Map<String, Object>> users;

        UserImportRequest(List<ImportUserRecord> users, UserImportOptions options, JsonFactory jsonFactory) {
            Preconditions.checkArgument((users != null && !users.isEmpty() ? 1 : 0) != 0, (Object)"users must not be null or empty");
            Preconditions.checkArgument((users.size() <= 1000 ? 1 : 0) != 0, (String)"users list must not contain more than %s items", (int)1000);
            boolean hasPassword = false;
            ImmutableList.Builder usersBuilder = ImmutableList.builder();
            for (ImportUserRecord user : users) {
                if (user.hasPassword()) {
                    hasPassword = true;
                }
                usersBuilder.add(user.getProperties(jsonFactory));
            }
            this.users = usersBuilder.build();
            if (hasPassword) {
                Preconditions.checkArgument((options != null && options.getHash() != null ? 1 : 0) != 0, (Object)"UserImportHash option is required when at least one user has a password. Provide a UserImportHash via UserImportOptions.withHash().");
                this.putAll(options.getProperties());
            }
        }

        int getUsersCount() {
            return this.users.size();
        }
    }
}

