/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.util.Clock;
import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.AbstractFirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.FirebaseTokenUtils;
import com.google.firebase.auth.FirebaseTokenVerifier;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.RevocationCheckDecorator;
import com.google.firebase.auth.SessionCookieOptions;
import com.google.firebase.auth.internal.FirebaseTokenFactory;
import com.google.firebase.auth.multitenancy.TenantManager;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;

public final class FirebaseAuth
extends AbstractFirebaseAuth {
    private static final String SERVICE_ID = FirebaseAuth.class.getName();
    private final Supplier<TenantManager> tenantManager;

    FirebaseAuth(final AbstractFirebaseAuth.Builder builder) {
        super(builder);
        this.tenantManager = this.threadSafeMemoize(new Supplier<TenantManager>(){

            public TenantManager get() {
                return new TenantManager(builder.firebaseApp);
            }
        });
    }

    public TenantManager getTenantManager() {
        return (TenantManager)this.tenantManager.get();
    }

    public static FirebaseAuth getInstance() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseAuth getInstance(FirebaseApp app) {
        FirebaseAuthService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseAuthService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseAuthService(app));
        }
        return (FirebaseAuth)service.getInstance();
    }

    public String createSessionCookie(@NonNull String idToken, @NonNull SessionCookieOptions options) throws FirebaseAuthException {
        return this.createSessionCookieOp(idToken, options).call();
    }

    public ApiFuture<String> createSessionCookieAsync(@NonNull String idToken, @NonNull SessionCookieOptions options) {
        return this.createSessionCookieOp(idToken, options).callAsync(this.getFirebaseApp());
    }

    private CallableOperation<String, FirebaseAuthException> createSessionCookieOp(final String idToken, final SessionCookieOptions options) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)idToken) ? 1 : 0) != 0, (Object)"idToken must not be null or empty");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            protected String execute() throws FirebaseAuthException {
                return userManager.createSessionCookie(idToken, options);
            }
        };
    }

    public FirebaseToken verifySessionCookie(String cookie) throws FirebaseAuthException {
        return this.verifySessionCookie(cookie, false);
    }

    public FirebaseToken verifySessionCookie(String cookie, boolean checkRevoked) throws FirebaseAuthException {
        return this.verifySessionCookieOp(cookie, checkRevoked).call();
    }

    public ApiFuture<FirebaseToken> verifySessionCookieAsync(String cookie) {
        return this.verifySessionCookieAsync(cookie, false);
    }

    public ApiFuture<FirebaseToken> verifySessionCookieAsync(String cookie, boolean checkRevoked) {
        return this.verifySessionCookieOp(cookie, checkRevoked).callAsync(this.getFirebaseApp());
    }

    private CallableOperation<FirebaseToken, FirebaseAuthException> verifySessionCookieOp(final String cookie, boolean checkRevoked) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cookie) ? 1 : 0) != 0, (Object)"Session cookie must not be null or empty");
        final FirebaseTokenVerifier sessionCookieVerifier = this.getSessionCookieVerifier(checkRevoked);
        return new CallableOperation<FirebaseToken, FirebaseAuthException>(){

            @Override
            public FirebaseToken execute() throws FirebaseAuthException {
                return sessionCookieVerifier.verifyToken(cookie);
            }
        };
    }

    @VisibleForTesting
    FirebaseTokenVerifier getSessionCookieVerifier(boolean checkRevoked) {
        FirebaseTokenVerifier verifier = this.getCookieVerifier();
        if (checkRevoked) {
            FirebaseUserManager userManager = this.getUserManager();
            verifier = RevocationCheckDecorator.decorateSessionCookieVerifier(verifier, userManager);
        }
        return verifier;
    }

    @Override
    protected void doDestroy() {
    }

    private static FirebaseAuth fromApp(final FirebaseApp app) {
        return new FirebaseAuth(AbstractFirebaseAuth.builder().setFirebaseApp(app).setTokenFactory(new Supplier<FirebaseTokenFactory>(){

            public FirebaseTokenFactory get() {
                return FirebaseTokenUtils.createTokenFactory(app, Clock.SYSTEM);
            }
        }).setIdTokenVerifier((Supplier<? extends FirebaseTokenVerifier>)new Supplier<FirebaseTokenVerifier>(){

            public FirebaseTokenVerifier get() {
                return FirebaseTokenUtils.createIdTokenVerifier(app, Clock.SYSTEM);
            }
        }).setCookieVerifier((Supplier<? extends FirebaseTokenVerifier>)new Supplier<FirebaseTokenVerifier>(){

            public FirebaseTokenVerifier get() {
                return FirebaseTokenUtils.createSessionCookieVerifier(app, Clock.SYSTEM);
            }
        }).setUserManager(new Supplier<FirebaseUserManager>(){

            public FirebaseUserManager get() {
                return FirebaseUserManager.builder().setFirebaseApp(app).build();
            }
        }));
    }

    private static class FirebaseAuthService
    extends FirebaseService<FirebaseAuth> {
        FirebaseAuthService(FirebaseApp app) {
            super(SERVICE_ID, FirebaseAuth.fromApp(app));
        }

        @Override
        public void destroy() {
            ((FirebaseAuth)this.instance).destroy();
        }
    }
}

