/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.snapshot.DeferredValueNode;
import com.google.firebase.database.snapshot.DoubleNode;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.LongNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.StringNode;

public class PriorityUtilities {
    public static Node NullPriority() {
        return EmptyNode.Empty();
    }

    public static boolean isValidPriority(Node priority) {
        return priority.getPriority().isEmpty() && (priority.isEmpty() || priority instanceof DoubleNode || priority instanceof StringNode || priority instanceof DeferredValueNode);
    }

    public static Node parsePriority(Object value) {
        Node priority = NodeUtilities.NodeFromJSON(value);
        if (priority instanceof LongNode) {
            priority = new DoubleNode((double)((Long)priority.getValue()), PriorityUtilities.NullPriority());
        }
        if (!PriorityUtilities.isValidPriority(priority)) {
            throw new DatabaseException("Invalid Firebase Database priority (must be a string, double, ServerValue, or null)");
        }
        return priority;
    }
}

