/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.LLRBValueNode;

public class LLRBBlackValueNode<K, V>
extends LLRBValueNode<K, V> {
    LLRBBlackValueNode(K key, V value, LLRBNode<K, V> left, LLRBNode<K, V> right) {
        super(key, value, left, right);
    }

    @Override
    protected LLRBNode.Color getColor() {
        return LLRBNode.Color.BLACK;
    }

    @Override
    public boolean isRed() {
        return false;
    }

    @Override
    protected LLRBValueNode<K, V> copy(K key, V value, LLRBNode<K, V> left, LLRBNode<K, V> right) {
        K newKey = key == null ? this.getKey() : key;
        V newValue = value == null ? this.getValue() : value;
        LLRBNode<K, V> newLeft = left == null ? this.getLeft() : left;
        LLRBNode<K, V> newRight = right == null ? this.getRight() : right;
        return new LLRBBlackValueNode<K, V>(newKey, newValue, newLeft, newRight);
    }
}

