/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.core.ApiFuture;
import com.google.common.base.Preconditions;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.OnCompleteListener;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TaskToApiFuture<T>
implements ApiFuture<T> {
    private final Task<T> task;
    private boolean cancelled;

    public TaskToApiFuture(Task<T> task) {
        this.task = (Task)Preconditions.checkNotNull(task, (Object)"task must not be null");
    }

    public void addListener(final Runnable runnable, Executor executor) {
        this.task.addOnCompleteListener(executor, new OnCompleteListener<T>(){

            @Override
            public void onComplete(Task<T> task) {
                runnable.run();
            }
        });
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return this.cancelled || this.task.isComplete();
    }

    public T get() throws InterruptedException, ExecutionException {
        return Tasks.await(this.task);
    }

    public T get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return Tasks.await(this.task, timeout, unit);
    }
}

