/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.GetTokenResult;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public final class FirebaseCloudCredentials
extends Credentials {
    private final FirebaseApp app;

    public FirebaseCloudCredentials(FirebaseApp app) {
        this.app = (FirebaseApp)Preconditions.checkNotNull((Object)app);
    }

    public String getAuthenticationType() {
        return "OAuth2";
    }

    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        Task<String> task = ImplFirebaseTrampolines.getToken(this.app, false).continueWith(new Continuation<GetTokenResult, String>(){

            @Override
            public String then(Task<GetTokenResult> task) throws Exception {
                return task.getResult().getToken();
            }
        });
        try {
            String authHeader = "Bearer " + Tasks.await(task);
            return ImmutableMap.of((Object)"Authorization", (Object)ImmutableList.of((Object)authHeader));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to acquire an OAuth token", e);
        }
    }

    public boolean hasRequestMetadata() {
        return true;
    }

    public boolean hasRequestMetadataOnly() {
        return true;
    }

    public void refresh() throws IOException {
        ImplFirebaseTrampolines.getToken(this.app, true);
    }
}

