/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.HashMap;
import java.util.Map;

public final class FirebaseOptions {
    private final String databaseUrl;
    private final FirebaseCredential firebaseCredential;
    private final Map<String, Object> databaseAuthVariableOverride;
    private final HttpTransport httpTransport;
    private final JsonFactory jsonFactory;

    private FirebaseOptions(@NonNull Builder builder) {
        this.firebaseCredential = (FirebaseCredential)Preconditions.checkNotNull((Object)builder.firebaseCredential, (Object)"FirebaseOptions must be initialized with setCredential().");
        this.databaseUrl = builder.databaseUrl;
        this.databaseAuthVariableOverride = builder.databaseAuthVariableOverride;
        this.httpTransport = (HttpTransport)Preconditions.checkNotNull((Object)builder.httpTransport, (Object)"FirebaseOptions must be initialized with a non-null HttpTransport.");
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)builder.jsonFactory, (Object)"FirebaseOptions must be initialized with a non-null JsonFactory.");
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    FirebaseCredential getCredential() {
        return this.firebaseCredential;
    }

    public Map<String, Object> getDatabaseAuthVariableOverride() {
        return this.databaseAuthVariableOverride;
    }

    @NonNull
    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    @NonNull
    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public static final class Builder {
        private String databaseUrl;
        private FirebaseCredential firebaseCredential;
        private Map<String, Object> databaseAuthVariableOverride = new HashMap<String, Object>();
        private HttpTransport httpTransport = Utils.getDefaultTransport();
        private JsonFactory jsonFactory = Utils.getDefaultJsonFactory();

        public Builder() {
        }

        public Builder(FirebaseOptions options) {
            this.databaseUrl = options.databaseUrl;
            this.firebaseCredential = options.firebaseCredential;
            this.databaseAuthVariableOverride = options.databaseAuthVariableOverride;
            this.httpTransport = options.httpTransport;
            this.jsonFactory = options.jsonFactory;
        }

        public Builder setDatabaseUrl(@Nullable String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        public Builder setCredential(@NonNull FirebaseCredential credential) {
            this.firebaseCredential = (FirebaseCredential)Preconditions.checkNotNull((Object)credential);
            return this;
        }

        public Builder setDatabaseAuthVariableOverride(@Nullable Map<String, Object> databaseAuthVariableOverride) {
            this.databaseAuthVariableOverride = databaseAuthVariableOverride;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this);
        }
    }
}

